/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import java.util.Arrays;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.compare.AbstractFileCompareSheet;
import org.spdx.compare.SpdxCompareException;
import org.spdx.compare.SpdxComparer;
import org.spdx.rdfparser.model.SpdxFile;

public class FileTypeSheet
extends AbstractFileCompareSheet {
    private static final int FILE_TYPE_COL_WIDTH = 20;

    public FileTypeSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    static void create(Workbook wb, String sheetName) {
        AbstractFileCompareSheet.create(wb, sheetName, 20);
    }

    @Override
    String getFileValue(SpdxFile spdxFile) {
        if (spdxFile.getFileTypes() == null || spdxFile.getFileTypes().length == 0) {
            return "";
        }
        SpdxFile.FileType[] fileTypes = spdxFile.getFileTypes();
        Object[] sFileTypes = new String[fileTypes.length];
        for (int i = 0; i < fileTypes.length; ++i) {
            sFileTypes[i] = fileTypes[i].getTag();
        }
        Arrays.sort(sFileTypes);
        StringBuilder sb = new StringBuilder((String)sFileTypes[0]);
        for (int i = 1; i < sFileTypes.length; ++i) {
            sb.append(", ");
            sb.append((String)sFileTypes[i]);
        }
        return sb.toString();
    }

    @Override
    boolean valuesMatch(SpdxComparer comparer, SpdxFile fileA, int docIndexA, SpdxFile fileB, int docIndexB) throws SpdxCompareException {
        return SpdxComparer.stringsEqual(this.getFileValue(fileA), this.getFileValue(fileB));
    }
}

