/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.License;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.core.DefaultStoreNotInitializedException;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.LicenseInfoFactory;
import org.spdx.library.model.v2.SpdxDocument;
import org.spdx.library.model.v2.license.AnyLicenseInfo;
import org.spdx.library.model.v2.license.ExtractedLicenseInfo;
import org.spdx.library.model.v2.license.InvalidLicenseStringException;
import org.spdx.library.model.v2.license.SpdxListedLicense;
import org.spdx.library.model.v2.license.SpdxNoAssertionLicense;
import org.spdx.maven.NonStandardLicense;
import org.spdx.maven.utils.LicenseManagerException;
import org.spdx.maven.utils.LicenseMapperException;
import org.spdx.maven.utils.MavenToSpdxLicenseMapper;
import org.spdx.storage.IModelStore;

public class SpdxV2LicenseManager {
    private static final Logger LOG = LoggerFactory.getLogger(SpdxV2LicenseManager.class);
    SpdxDocument spdxDoc;
    Map<String, String> urlStringToSpdxLicenseId = new HashMap<String, String>();
    Map<String, ExtractedLicenseInfo> extractedLicenses = new HashMap<String, ExtractedLicenseInfo>();

    public SpdxV2LicenseManager(SpdxDocument spdxDoc) throws LicenseMapperException {
        this.spdxDoc = spdxDoc;
        this.initializeUrlMap();
    }

    private void initializeUrlMap() throws LicenseMapperException {
        this.urlStringToSpdxLicenseId.putAll(MavenToSpdxLicenseMapper.getInstance().getMap());
    }

    public void addExtractedLicense(NonStandardLicense license) throws LicenseManagerException {
        ExtractedLicenseInfo spdxLicense;
        try {
            spdxLicense = new ExtractedLicenseInfo(this.spdxDoc.getModelStore(), this.spdxDoc.getDocumentUri(), license.getLicenseId(), this.spdxDoc.getCopyManager(), true);
            spdxLicense.setExtractedText(license.getExtractedText());
            spdxLicense.setName(license.getName());
            for (String crossRef : license.getCrossReference()) {
                spdxLicense.getSeeAlso().add(crossRef);
            }
            spdxLicense.setComment(license.getComment());
            this.spdxDoc.addExtractedLicenseInfos(spdxLicense);
        }
        catch (InvalidSPDXAnalysisException e) {
            String licenseId = license.getLicenseId();
            if (licenseId == null) {
                licenseId = "[NullLicenseId]";
            }
            throw new LicenseManagerException("Unable to add non listed license " + licenseId, e);
        }
        String[] urls = license.getCrossReference();
        if (urls != null) {
            for (String url : urls) {
                if (this.urlStringToSpdxLicenseId.containsKey(url)) {
                    String oldLicenseId = this.urlStringToSpdxLicenseId.get(url);
                    LOG.warn("Duplicate URL for SPDX extracted license.  Replacing {} with {} for {}", new Object[]{oldLicenseId, license.getLicenseId(), url});
                }
                LOG.debug("Adding URL mapping for non-standard license {}", (Object)spdxLicense.getLicenseId());
                this.urlStringToSpdxLicenseId.put(url, spdxLicense.getLicenseId());
            }
        }
        this.extractedLicenses.put(spdxLicense.getLicenseId(), spdxLicense);
    }

    public AnyLicenseInfo mavenLicenseListToSpdxLicense(List<License> licenseList) throws LicenseManagerException {
        try {
            if (licenseList == null) {
                return new SpdxNoAssertionLicense();
            }
            ArrayList<AnyLicenseInfo> spdxLicenses = new ArrayList<AnyLicenseInfo>();
            for (License license : licenseList) {
                spdxLicenses.add(this.mavenLicenseToSpdxLicense(license));
            }
            if (spdxLicenses.isEmpty()) {
                return new SpdxNoAssertionLicense();
            }
            if (spdxLicenses.size() == 1) {
                return (AnyLicenseInfo)spdxLicenses.get(0);
            }
            return this.spdxDoc.createConjunctiveLicenseSet(spdxLicenses);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new LicenseManagerException("Error converting Maven license to SPDX license", e);
        }
    }

    public AnyLicenseInfo mavenLicenseToSpdxLicense(License mavenLicense) throws LicenseManagerException {
        if (mavenLicense.getUrl() == null) {
            throw new LicenseManagerException("Can not map maven license " + mavenLicense.getName() + "  No URL exists to provide a mapping");
        }
        String licenseId = this.urlStringToSpdxLicenseId.get(mavenLicense.getUrl().replaceAll("https:", "http:"));
        if (licenseId == null) {
            throw new LicenseManagerException("Can not map maven license " + mavenLicense.getName() + "  No listed or extracted license matches the URL " + mavenLicense.getUrl());
        }
        AnyLicenseInfo retval = (AnyLicenseInfo)this.extractedLicenses.get(licenseId);
        if (retval == null) {
            try {
                retval = LicenseInfoFactory.parseSPDXLicenseStringCompatV2((String)licenseId, (IModelStore)this.spdxDoc.getModelStore(), (String)this.spdxDoc.getDocumentUri(), (IModelCopyManager)this.spdxDoc.getCopyManager());
            }
            catch (InvalidLicenseStringException e) {
                throw new LicenseManagerException("Can not map maven license " + mavenLicense.getName() + "  Invalid listed or extracted license id matching the URL " + mavenLicense.getUrl());
            }
            catch (DefaultStoreNotInitializedException e) {
                throw new LicenseManagerException("Default model store not initialized");
            }
        }
        return retval;
    }

    public License spdxLicenseToMavenLicense(AnyLicenseInfo spdxLicense) throws LicenseManagerException {
        if (spdxLicense instanceof ExtractedLicenseInfo) {
            return this.spdxNonStdLicenseToMavenLicense((ExtractedLicenseInfo)spdxLicense);
        }
        if (spdxLicense instanceof SpdxListedLicense) {
            return this.spdxStdLicenseToMavenLicense((SpdxListedLicense)spdxLicense);
        }
        throw new LicenseManagerException("Can not create a Maven license from this SPDX license type.  Must be an ExtractedLicenseInfo or an SpdxListedLicense ");
    }

    private License spdxStdLicenseToMavenLicense(SpdxListedLicense spdxLicense) throws LicenseManagerException {
        try {
            License retval = new License();
            if (spdxLicense.getName() != null && !spdxLicense.getName().isEmpty()) {
                retval.setName(spdxLicense.getName());
            } else {
                retval.setName(spdxLicense.getLicenseId());
            }
            if (spdxLicense.getComment() != null && !spdxLicense.getComment().isEmpty()) {
                retval.setComments(spdxLicense.getComment());
            }
            for (String url : spdxLicense.getSeeAlso()) {
                retval.setUrl(url);
            }
            if (spdxLicense.getSeeAlso().size() > 1) {
                LOG.warn("SPDX license {} contains multiple URLs.  Only the first URL will be preserved in the Maven license created.", (Object)spdxLicense.getLicenseId());
            }
            return retval;
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new LicenseManagerException("Error converting SPDX Listed License to Maven license", e);
        }
    }

    private License spdxNonStdLicenseToMavenLicense(ExtractedLicenseInfo spdxLicense) throws LicenseManagerException {
        try {
            License retval = new License();
            if (spdxLicense.getName() != null && !spdxLicense.getName().isEmpty()) {
                retval.setName(spdxLicense.getName());
            } else {
                retval.setName(spdxLicense.getLicenseId());
            }
            if (spdxLicense.getComment() != null && !spdxLicense.getComment().isEmpty()) {
                retval.setComments(spdxLicense.getComment());
            }
            for (String url : spdxLicense.getSeeAlso()) {
                retval.setUrl(url);
            }
            if (spdxLicense.getSeeAlso().size() > 1) {
                LOG.warn("SPDX license {} contains multiple URLs.  Only the first URL will be preserved in the Maven license created.", (Object)spdxLicense.getLicenseId());
            }
            return retval;
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new LicenseManagerException("Error converting SPDX non-standard license to Maven license", e);
        }
    }
}

