/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.Checksum;
import org.spdx.library.model.ExternalRef;
import org.spdx.library.model.SpdxDocument;
import org.spdx.library.model.enumerations.Purpose;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.library.model.license.SpdxNoAssertionLicense;
import org.spdx.library.referencetype.ListedReferenceTypes;
import org.spdx.maven.Annotation;
import org.spdx.maven.ExternalReference;
import org.spdx.maven.utils.SpdxFileCollector;

public class SpdxProjectInformation {
    private static final Logger LOG = LoggerFactory.getLogger(SpdxProjectInformation.class);
    private String[] creators = new String[0];
    private String creatorComment = "";
    private AnyLicenseInfo concludedLicense = new SpdxNoAssertionLicense();
    private AnyLicenseInfo declaredLicense = new SpdxNoAssertionLicense();
    private String description;
    private String downloadUrl;
    private String homePage;
    private String shortDescription;
    private String originator;
    private String supplier;
    private String packageArchiveFileName;
    private String versionInfo;
    private String licenseComment;
    private String name;
    private String sourceInfo;
    private String copyrightText;
    private String documentComment;
    private Annotation[] packageAnnotations;
    private Annotation[] documentAnnotations;
    private ExternalReference[] externalRefs;
    private Set<Checksum> checksums;
    private Purpose primaryPurpose;

    public Purpose getPrimaryPurpose() {
        return this.primaryPurpose;
    }

    public void setPrimaryPurpose(Purpose primaryPurpose) {
        this.primaryPurpose = primaryPurpose;
    }

    public String getDocumentComment() {
        return this.documentComment;
    }

    public void setDocumentComment(String documentComment) {
        this.documentComment = documentComment;
    }

    public Set<Checksum> getChecksums() {
        return this.checksums;
    }

    public void setChecksums(Set<Checksum> checksums) {
        this.checksums = checksums;
    }

    public AnyLicenseInfo getConcludedLicense() {
        return this.concludedLicense;
    }

    public void setConcludedLicense(AnyLicenseInfo concludedLicense) {
        this.concludedLicense = concludedLicense;
    }

    public AnyLicenseInfo getDeclaredLicense() {
        return this.declaredLicense;
    }

    public void setDeclaredLicense(AnyLicenseInfo declaredLicense) {
        this.declaredLicense = declaredLicense;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public String getHomePage() {
        return this.homePage;
    }

    public void setHomePage(String homePage) {
        this.homePage = homePage;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public String getOriginator() {
        return this.originator;
    }

    public void setOriginator(String originator) {
        this.originator = originator;
    }

    public String getSupplier() {
        return this.supplier;
    }

    public void setSupplier(String supplier) {
        this.supplier = supplier;
    }

    public String getPackageArchiveFileName() {
        return this.packageArchiveFileName;
    }

    public void setPackageArchiveFileName(String packageArchiveFileName) {
        this.packageArchiveFileName = packageArchiveFileName;
    }

    public String getVersionInfo() {
        return this.versionInfo;
    }

    public void setVersionInfo(String versionInfo) {
        this.versionInfo = versionInfo;
    }

    public String getLicenseComment() {
        return this.licenseComment;
    }

    public void setLicenseComment(String licenseComment) {
        this.licenseComment = licenseComment;
    }

    public String[] getCreators() {
        return this.creators;
    }

    public void setCreators(String[] creators) {
        this.creators = creators;
    }

    public String getCreatorComment() {
        return this.creatorComment;
    }

    public void setCreatorComment(String creatorComment) {
        this.creatorComment = creatorComment;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void logInfo(SpdxDocument spdxDoc) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug("SPDX Project Name: " + this.getName());
        LOG.debug("SPDX Document comment: " + this.getDocumentComment());
        LOG.debug("SPDX Creator comment: " + this.getCreatorComment());
        LOG.debug("SPDX Description: " + this.getDescription());
        LOG.debug("SPDX License comment: " + this.getLicenseComment());
        LOG.debug("SPDX Originator: " + this.getOriginator());
        LOG.debug("SPDX PackageArchiveFileName: " + this.getPackageArchiveFileName());
        LOG.debug("SPDX Short description: " + this.getShortDescription());
        LOG.debug("SPDX Supplier: " + this.getSupplier());
        LOG.debug("SPDX Source Info:  " + this.getSourceInfo());
        LOG.debug("SPDX Version info: " + this.getVersionInfo());
        LOG.debug("SPDX Concluded license: " + this.getConcludedLicense().toString());
        LOG.debug("SPDX Declared license: " + this.getDeclaredLicense().toString());
        LOG.debug("SPDX Download URL: " + this.getDownloadUrl());
        LOG.debug("SPDX Home page: " + this.getHomePage());
        if (this.documentAnnotations != null && this.documentAnnotations.length > 0) {
            LOG.debug("Document annotations: ");
            for (Annotation annotation : this.documentAnnotations) {
                annotation.logInfo();
            }
        }
        if (this.packageAnnotations != null && this.packageAnnotations.length > 0) {
            LOG.debug("Package annotations: ");
            for (Annotation annotation : this.packageAnnotations) {
                annotation.logInfo();
            }
        }
        if (this.creators != null) {
            for (String string : this.creators) {
                LOG.debug("SPDX Creator: " + (String)string);
            }
        }
        if (this.externalRefs != null) {
            for (ExternalReference externalReference : this.externalRefs) {
                try {
                    ExternalRef externalRef = externalReference.getExternalRef(spdxDoc);
                    StringBuilder externalRefString = new StringBuilder();
                    try {
                        externalRefString.append(externalRef.getReferenceCategory().toString());
                    }
                    catch (InvalidSPDXAnalysisException e1) {
                        externalRefString.append("Invalid Reference Category");
                    }
                    externalRefString.append(' ');
                    try {
                        externalRefString.append(ListedReferenceTypes.getListedReferenceTypes().getListedReferenceName(new URI(externalRef.getReferenceType().getIndividualURI())));
                    }
                    catch (URISyntaxException | InvalidSPDXAnalysisException e) {
                        externalRefString.append("Invalid Reference Type");
                    }
                    externalRefString.append(' ');
                    try {
                        externalRefString.append(externalRef.getReferenceLocator());
                    }
                    catch (InvalidSPDXAnalysisException e) {
                        externalRefString.append("Invalid Reference Locator");
                    }
                    LOG.debug("External Ref: " + externalRefString.toString());
                }
                catch (MojoExecutionException e1) {
                    LOG.error("Invalid external reference", (Throwable)e1);
                }
            }
        }
        if (this.checksums != null && this.checksums.size() > 0) {
            for (Checksum checksum : this.checksums) {
                try {
                    String algorithm = SpdxFileCollector.checksumAlgorithms.get(checksum.getAlgorithm());
                    LOG.debug("SPDX " + algorithm + ": " + checksum.getValue());
                }
                catch (InvalidSPDXAnalysisException e) {
                    LOG.debug("Invalid SPDX checksum");
                }
            }
        }
    }

    public String getSourceInfo() {
        return this.sourceInfo;
    }

    public void setSourceInfo(String sourceInformation) {
        this.sourceInfo = sourceInformation;
    }

    public void setCopyrightText(String copyrightText) {
        this.copyrightText = copyrightText;
    }

    public String getCopyrightText() {
        return this.copyrightText;
    }

    public void setPackageAnnotations(Annotation[] packageAnnotations) {
        this.packageAnnotations = packageAnnotations;
    }

    public Annotation[] getPackageAnnotations() {
        return this.packageAnnotations;
    }

    public void setDocumentAnnotations(Annotation[] documentAnnotations) {
        this.documentAnnotations = documentAnnotations;
    }

    public Annotation[] getDocumentAnnotations() {
        return this.documentAnnotations;
    }

    public void setExternalRefs(ExternalReference[] externalReferences) {
        this.externalRefs = externalReferences;
    }

    public ExternalReference[] getExternalRefs() {
        return this.externalRefs;
    }
}

