/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven;

import org.apache.maven.plugin.MojoExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.SpdxDocument;
import org.spdx.library.model.enumerations.AnnotationType;

public class Annotation {
    private static final Logger LOG = LoggerFactory.getLogger(Annotation.class);
    private String annotationType;
    private String annotationDate;
    private String annotator;
    private String annotationComment;

    public String getAnnotationType() {
        return this.annotationType;
    }

    public void setAnnotationType(String annotationType) {
        this.annotationType = annotationType;
    }

    public String getAnnotationDate() {
        return this.annotationDate;
    }

    public void setAnnotationDate(String annotationDate) {
        this.annotationDate = annotationDate;
    }

    public String getAnnotator() {
        return this.annotator;
    }

    public void setAnnotator(String annotator) {
        this.annotator = annotator;
    }

    public String getAnnotationComment() {
        return this.annotationComment;
    }

    public void setAnnotationComment(String annotationComment) {
        this.annotationComment = annotationComment;
    }

    public org.spdx.library.model.Annotation toSpdxAnnotation(SpdxDocument spdxDoc) throws MojoExecutionException {
        AnnotationType annotationType = AnnotationType.OTHER;
        try {
            annotationType = AnnotationType.valueOf((String)this.annotationType);
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Invalid annotation type " + this.annotationType);
        }
        try {
            return spdxDoc.createAnnotation(this.annotator, annotationType, this.annotationDate, this.annotationComment);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new MojoExecutionException("Error creating annotation.", (Exception)((Object)e));
        }
    }

    public void logInfo() {
        LOG.debug("Annotator: " + this.annotator + ", Date: " + this.annotationDate + ", Type: " + this.annotationType);
    }
}

