/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.utility.verificationcode;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.SpdxFile;
import org.spdx.library.model.SpdxPackageVerificationCode;
import org.spdx.storage.IModelStore;
import org.spdx.utility.verificationcode.IFileChecksumGenerator;

public class VerificationCodeGenerator {
    private IFileChecksumGenerator fileChecksumGenerator;

    public VerificationCodeGenerator(IFileChecksumGenerator fileChecksumGenerator) {
        this.fileChecksumGenerator = fileChecksumGenerator;
    }

    public SpdxPackageVerificationCode generatePackageVerificationCode(SpdxFile[] spdxFiles, String[] skippedFilePaths, IModelStore modelStore, String documentUri) throws NoSuchAlgorithmException, InvalidSPDXAnalysisException {
        if (spdxFiles == null) {
            return null;
        }
        TreeSet<String> skippedFilePathSet = new TreeSet<String>();
        if (skippedFilePaths != null) {
            for (int i = 0; i < skippedFilePaths.length; ++i) {
                if (skippedFilePaths[i] == null) continue;
                skippedFilePathSet.add(skippedFilePaths[i]);
            }
        }
        ArrayList<String> fileChecksums = new ArrayList<String>();
        for (int i = 0; i < spdxFiles.length; ++i) {
            Optional<String> name;
            if (spdxFiles[i] == null || !(name = spdxFiles[i].getName()).isPresent() || skippedFilePathSet.contains(name.get())) continue;
            fileChecksums.add(spdxFiles[i].getSha1());
        }
        return this.generatePackageVerificationCode(fileChecksums, skippedFilePathSet.toArray(new String[skippedFilePathSet.size()]), modelStore, documentUri);
    }

    public SpdxPackageVerificationCode generatePackageVerificationCode(File sourceDirectory, File[] skippedFiles, IModelStore modelStore, String documentUri) throws NoSuchAlgorithmException, IOException, InvalidSPDXAnalysisException {
        TreeSet<String> skippedFilesPath = new TreeSet<String>();
        String rootOfDirectory = sourceDirectory.getAbsolutePath();
        int rootLen = rootOfDirectory.length() + 1;
        for (int i = 0; i < skippedFiles.length; ++i) {
            String skippedPath = VerificationCodeGenerator.normalizeFilePath(skippedFiles[i].getAbsolutePath().substring(rootLen));
            skippedFilesPath.add(skippedPath);
        }
        ArrayList<String> fileChecksums = new ArrayList<String>();
        this.collectFileData(rootOfDirectory, sourceDirectory, fileChecksums, skippedFilesPath);
        String[] skippedFileNames = new String[skippedFilesPath.size()];
        Iterator iter = skippedFilesPath.iterator();
        int i = 0;
        while (iter.hasNext()) {
            skippedFileNames[i++] = (String)iter.next();
        }
        return this.generatePackageVerificationCode(fileChecksums, skippedFileNames, modelStore, documentUri);
    }

    protected SpdxPackageVerificationCode generatePackageVerificationCode(List<String> fileChecksums, String[] skippedFilePaths, IModelStore modelStore, String documentUri) throws NoSuchAlgorithmException, InvalidSPDXAnalysisException {
        Collections.sort(fileChecksums);
        MessageDigest verificationCodeDigest = MessageDigest.getInstance("SHA-1");
        for (int i = 0; i < fileChecksums.size(); ++i) {
            byte[] hashInput = fileChecksums.get(i).getBytes(Charset.forName("UTF-8"));
            verificationCodeDigest.update(hashInput);
        }
        String value = VerificationCodeGenerator.convertChecksumToString(verificationCodeDigest.digest());
        SpdxPackageVerificationCode retval = new SpdxPackageVerificationCode(modelStore, documentUri, modelStore.getNextId(IModelStore.IdType.Anonymous, documentUri), null, true);
        retval.setValue(value);
        for (String skippedPath : skippedFilePaths) {
            retval.getExcludedFileNames().add(skippedPath);
        }
        return retval;
    }

    private void collectFileData(String prefixForRelative, File sourceDirectory, List<String> fileNameAndChecksums, Set<String> skippedFiles) throws IOException {
        if (!sourceDirectory.isDirectory()) {
            return;
        }
        File[] filesAndDirs = sourceDirectory.listFiles();
        if (filesAndDirs == null) {
            return;
        }
        for (int i = 0; i < filesAndDirs.length; ++i) {
            if (filesAndDirs[i].isDirectory()) {
                this.collectFileData(prefixForRelative, filesAndDirs[i], fileNameAndChecksums, skippedFiles);
                continue;
            }
            String filePath = VerificationCodeGenerator.normalizeFilePath(filesAndDirs[i].getAbsolutePath().substring(prefixForRelative.length() + 1));
            if (skippedFiles.contains(filePath)) continue;
            String checksumValue = this.fileChecksumGenerator.getFileChecksum(filesAndDirs[i]).toLowerCase();
            fileNameAndChecksums.add(checksumValue);
        }
    }

    public static String normalizeFilePath(String nonNormalizedFilePath) {
        String filePath = nonNormalizedFilePath.replace('\\', '/').trim();
        if (filePath.contains("../")) {
            String[] filePathParts = filePath.split("/");
            StringBuilder normalizedFilePath = new StringBuilder();
            for (int j = 0; j < filePathParts.length; ++j) {
                if (j + 1 < filePathParts.length && filePathParts[j + 1].equals("..") || filePathParts[j].equals("..")) continue;
                if (j > 0) {
                    normalizedFilePath.append('/');
                }
                normalizedFilePath.append(filePathParts[j]);
            }
            filePath = normalizedFilePath.toString();
        }
        filePath = !(filePath = filePath.replace("./", "")).isEmpty() && filePath.charAt(0) == '/' ? "." + filePath : "./" + filePath;
        return filePath;
    }

    private static String convertChecksumToString(byte[] digest) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < digest.length; ++i) {
            String hex = Integer.toHexString(0xFF & digest[i]);
            if (hex.length() < 2) {
                sb.append('0');
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public SpdxPackageVerificationCode generatePackageVerificationCode(File sourceDirectory, IModelStore modelStore, String documentUri) throws NoSuchAlgorithmException, IOException, InvalidSPDXAnalysisException {
        return this.generatePackageVerificationCode(sourceDirectory, new File[0], modelStore, documentUri);
    }
}

