/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.utility.compare;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.spdx.licenseTemplate.ILicenseTemplateOutputHandler;
import org.spdx.licenseTemplate.LicenseTemplateRule;
import org.spdx.utility.compare.LicenseCompareHelper;
import org.spdx.utility.compare.LineColumn;

@Deprecated
public class FilterTemplateOutputHandler
implements ILicenseTemplateOutputHandler {
    public static final String REGEX_ESCAPE = "~~~";
    private VarTextHandling varTextHandling;
    private OptionalTextHandling optionalTextHandling;
    private List<String> filteredText = new ArrayList<String>();
    StringBuilder currentString = new StringBuilder();
    private int optionalDepth = 0;
    private Map<Integer, List<String>> optionalTokens = new HashMap<Integer, List<String>>();

    @Deprecated
    public FilterTemplateOutputHandler(boolean includeVarText) {
        this(includeVarText ? VarTextHandling.ORIGINAL : VarTextHandling.OMIT, OptionalTextHandling.OMIT);
    }

    public FilterTemplateOutputHandler(VarTextHandling varTextHandling) {
        this(varTextHandling, OptionalTextHandling.OMIT);
    }

    public FilterTemplateOutputHandler(VarTextHandling varTextHandling, OptionalTextHandling optionalTextHandling) {
        this.varTextHandling = varTextHandling;
        this.optionalTextHandling = optionalTextHandling;
    }

    @Override
    public void text(String text) {
        if (this.optionalDepth <= 0 || OptionalTextHandling.ORIGINAL.equals((Object)this.optionalTextHandling)) {
            this.currentString.append(text);
        } else if (OptionalTextHandling.REGEX_USING_TOKENS.equals((Object)this.optionalTextHandling)) {
            this.optionalTokens.get(this.optionalDepth).addAll(Arrays.asList(LicenseCompareHelper.tokenizeLicenseText(text, new HashMap<Integer, LineColumn>())));
        }
    }

    @Override
    public void variableRule(LicenseTemplateRule rule) {
        if (VarTextHandling.REGEX.equals((Object)this.varTextHandling) && this.optionalDepth <= 0) {
            this.currentString.append(REGEX_ESCAPE);
            this.currentString.append('(');
            this.currentString.append(rule.getMatch());
            this.currentString.append(')');
            this.currentString.append(REGEX_ESCAPE);
        } else if (VarTextHandling.ORIGINAL.equals((Object)this.varTextHandling) && this.optionalDepth <= 0) {
            this.currentString.append(rule.getOriginal());
        } else if (this.optionalDepth > 0 && OptionalTextHandling.REGEX_USING_TOKENS.equals((Object)this.optionalTextHandling)) {
            this.currentString.append('(');
            this.currentString.append(rule.getMatch());
            this.currentString.append(')');
        } else if (this.currentString.length() > 0) {
            this.filteredText.add(this.currentString.toString());
            this.currentString.setLength(0);
        }
    }

    @Override
    public void beginOptional(LicenseTemplateRule rule) {
        if (OptionalTextHandling.REGEX_USING_TOKENS.equals((Object)this.optionalTextHandling)) {
            if (this.optionalDepth == 0) {
                if (this.currentString.length() > 0) {
                    this.filteredText.add(this.currentString.toString());
                    this.currentString.setLength(0);
                }
                this.currentString.append(REGEX_ESCAPE);
            } else {
                this.currentString.append(this.toTokenRegex(this.optionalTokens.get(this.optionalDepth)));
                this.optionalTokens.get(this.optionalDepth).clear();
            }
            this.currentString.append('(');
        } else if (this.currentString.length() > 0) {
            this.filteredText.add(this.currentString.toString());
            this.currentString.setLength(0);
        }
        ++this.optionalDepth;
        this.optionalTokens.put(this.optionalDepth, new ArrayList());
    }

    private String toTokenRegex(List<String> tokens) {
        StringBuilder sb = new StringBuilder();
        for (String token : tokens) {
            if (LicenseCompareHelper.NORMALIZE_TOKENS.containsKey((token = token.trim()).toLowerCase())) {
                token = LicenseCompareHelper.NORMALIZE_TOKENS.get(token.toLowerCase());
            }
            sb.append(Pattern.quote(token));
            sb.append("\\s*");
        }
        return sb.toString();
    }

    @Override
    public void endOptional(LicenseTemplateRule rule) {
        if (OptionalTextHandling.REGEX_USING_TOKENS.equals((Object)this.optionalTextHandling)) {
            this.currentString.append(this.toTokenRegex(this.optionalTokens.get(this.optionalDepth)));
            this.currentString.append(")?");
            if (this.optionalDepth == 1) {
                this.currentString.append(REGEX_ESCAPE);
                this.filteredText.add(this.currentString.toString());
                this.currentString.setLength(0);
            }
        } else if (this.currentString.length() > 0) {
            this.filteredText.add(this.currentString.toString());
            this.currentString.setLength(0);
        }
        this.optionalTokens.remove(this.optionalDepth);
        --this.optionalDepth;
    }

    @Override
    public void completeParsing() {
        if (this.currentString.length() > 0) {
            this.filteredText.add(this.currentString.toString());
            this.currentString.setLength(0);
        }
    }

    public boolean isIncludeVarText() {
        return VarTextHandling.ORIGINAL.equals((Object)this.varTextHandling);
    }

    public VarTextHandling getVarTextHandling() {
        return this.varTextHandling;
    }

    public List<String> getFilteredText() {
        return this.filteredText;
    }

    public static enum VarTextHandling {
        OMIT,
        ORIGINAL,
        REGEX;

    }

    public static enum OptionalTextHandling {
        OMIT,
        ORIGINAL,
        REGEX_USING_TOKENS;

    }
}

