/*
 * Decompiled with CFR 0.152.
 */
package net.razorvine.pyro;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.razorvine.pyro.Config;
import net.razorvine.pyro.IOUtil;
import net.razorvine.pyro.PyroException;

public class Message {
    private static final int CHECKSUM_MAGIC = 13545;
    public static final int HEADER_SIZE = 24;
    public static final int MSG_CONNECT = 1;
    public static final int MSG_CONNECTOK = 2;
    public static final int MSG_CONNECTFAIL = 3;
    public static final int MSG_INVOKE = 4;
    public static final int MSG_RESULT = 5;
    public static final int MSG_PING = 6;
    public static final int FLAGS_EXCEPTION = 1;
    public static final int FLAGS_COMPRESSED = 2;
    public static final int FLAGS_ONEWAY = 4;
    public static final int FLAGS_BATCH = 8;
    public static final int SERIALIZER_SERPENT = 1;
    public static final int SERIALIZER_JSON = 2;
    public static final int SERIALIZER_MARSHAL = 3;
    public static final int SERIALIZER_PICKLE = 4;
    public int type;
    public int flags;
    public byte[] data;
    public int data_size;
    public int annotations_size;
    public int serializer_id;
    public int seq;
    public Map<String, byte[]> annotations;

    public Message(int n, int n2, int n3, int n4) {
        this.type = n;
        this.flags = n3;
        this.seq = n4;
        this.serializer_id = n2;
    }

    public Message(int n, byte[] byArray, int n2, int n3, int n4, Map<String, byte[]> map) {
        this(n, n2, n3, n4);
        this.data = byArray;
        this.data_size = byArray.length;
        this.annotations = map;
        if (null == map) {
            this.annotations = new HashMap<String, byte[]>(0);
        }
        if (Config.HMAC_KEY != null) {
            this.annotations.put("HMAC", this.hmac());
        }
        this.annotations_size = 0;
        for (Map.Entry<String, byte[]> entry : this.annotations.entrySet()) {
            this.annotations_size += entry.getValue().length + 6;
        }
    }

    protected byte[] hmac() {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(Config.HMAC_KEY, "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(secretKeySpec);
            mac.update(this.data);
            for (Map.Entry<String, byte[]> entry : this.annotations.entrySet()) {
                if (entry.getKey().equals("HMAC")) continue;
                mac.update(entry.getValue());
            }
            return mac.doFinal();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PyroException("invalid hmac algorithm", noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PyroException("invalid hmac key", invalidKeyException);
        }
    }

    public byte[] to_bytes() {
        byte[] byArray = this.get_header_bytes();
        byte[] byArray2 = this.get_annotations_bytes();
        byte[] byArray3 = new byte[byArray.length + byArray2.length + this.data.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        System.arraycopy(this.data, 0, byArray3, byArray.length + byArray2.length, this.data.length);
        return byArray3;
    }

    public byte[] get_header_bytes() {
        int n = this.type + 46 + this.data_size + this.annotations_size + this.serializer_id + this.flags + this.seq + 13545 & 0xFFFF;
        byte[] byArray = new byte[]{80, 89, 82, 79, 0, 46, (byte)(this.type >> 8), (byte)(this.type & 0xFF), (byte)(this.flags >> 8), (byte)(this.flags & 0xFF), (byte)(this.seq >> 8), (byte)(this.seq & 0xFF), (byte)(this.data_size >> 24 & 0xFF), (byte)(this.data_size >> 16 & 0xFF), (byte)(this.data_size >> 8 & 0xFF), (byte)(this.data_size & 0xFF), (byte)(this.serializer_id >> 8), (byte)(this.serializer_id & 0xFF), (byte)(this.annotations_size >> 8 & 0xFF), (byte)(this.annotations_size & 0xFF), 0, 0, (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        return byArray;
    }

    public byte[] get_annotations_bytes() {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        int n = 0;
        for (Map.Entry<String, byte[]> entry : this.annotations.entrySet()) {
            String string = entry.getKey();
            byte[] byArray = entry.getValue();
            if (string.length() != 4) {
                throw new IllegalArgumentException("annotation key must be length 4");
            }
            arrayList.add(string.getBytes());
            byte[] byArray2 = new byte[]{(byte)(byArray.length >> 8 & 0xFF), (byte)(byArray.length & 0xFF)};
            arrayList.add(byArray2);
            arrayList.add(byArray);
            n += 6 + byArray.length;
        }
        Object object = new byte[n];
        int n2 = 0;
        for (byte[] byArray : arrayList) {
            System.arraycopy(byArray, 0, object, n2, byArray.length);
            n2 += byArray.length;
        }
        return object;
    }

    public static Message from_header(byte[] byArray) {
        if (byArray == null || byArray.length != 24) {
            throw new PyroException("header data size mismatch");
        }
        if (byArray[0] != 80 || byArray[1] != 89 || byArray[2] != 82 || byArray[3] != 79) {
            throw new PyroException("invalid message");
        }
        int n = (byArray[4] & 0xFF) << 8 | byArray[5] & 0xFF;
        if (n != 46) {
            throw new PyroException("invalid protocol version: " + n);
        }
        int n2 = (byArray[6] & 0xFF) << 8 | byArray[7] & 0xFF;
        int n3 = (byArray[8] & 0xFF) << 8 | byArray[9] & 0xFF;
        int n4 = (byArray[10] & 0xFF) << 8 | byArray[11] & 0xFF;
        int n5 = byArray[12] & 0xFF;
        n5 <<= 8;
        n5 |= byArray[13] & 0xFF;
        n5 <<= 8;
        n5 |= byArray[14] & 0xFF;
        n5 <<= 8;
        int n6 = (byArray[22] & 0xFF) << 8 | byArray[23] & 0xFF;
        int n7 = (byArray[18] & 0xFF) << 8 | byArray[19] & 0xFF;
        int n8 = (byArray[16] & 0xFF) << 8 | byArray[17] & 0xFF;
        int n9 = n2 + n + (n5 |= byArray[15] & 0xFF) + n7 + n3 + n8 + n4 + 13545 & 0xFFFF;
        if (n6 != n9) {
            throw new PyroException("header checksum mismatch");
        }
        Message message = new Message(n2, n8, n3, n4);
        message.data_size = n5;
        message.annotations_size = n7;
        return message;
    }

    public static Message recv(InputStream inputStream, int[] nArray) throws IOException {
        int n;
        byte[] byArray = IOUtil.recv(inputStream, 24);
        Message message = Message.from_header(byArray);
        if (nArray != null) {
            boolean bl = false;
            int[] nArray2 = nArray;
            int n2 = nArray2.length;
            for (n = 0; n < n2; ++n) {
                int n3 = nArray2[n];
                if (n3 != message.type) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new PyroException(String.format("invalid msg type %d received", message.type));
            }
        }
        byte[] byArray2 = null;
        message.annotations = new HashMap<String, byte[]>();
        if (message.annotations_size > 0) {
            byArray2 = IOUtil.recv(inputStream, message.annotations_size);
            for (int i = 0; i < message.annotations_size; i += 6 + n) {
                String string = new String(byArray2, i, 4);
                n = byArray2[i + 4] << 8 | byArray2[i + 5];
                byte[] byArray3 = new byte[n];
                System.arraycopy(byArray2, i + 6, byArray3, 0, n);
                message.annotations.put(string, byArray3);
            }
        }
        message.data = IOUtil.recv(inputStream, message.data_size);
        if (Config.MSG_TRACE_DIR != null) {
            Message.TraceMessageRecv(message.seq, byArray, byArray2, message.data);
        }
        if (message.annotations.containsKey("HMAC") && Config.HMAC_KEY != null) {
            if (!Arrays.equals(message.annotations.get("HMAC"), message.hmac())) {
                throw new PyroException("message hmac mismatch");
            }
        } else if (message.annotations.containsKey("HMAC") != (Config.HMAC_KEY != null)) {
            throw new PyroException("hmac key config not symmetric");
        }
        return message;
    }

    public static void TraceMessageSend(int n, byte[] byArray, byte[] byArray2, byte[] byArray3) throws IOException {
        String string = String.format("%s%s%05d-a-send-header.dat", Config.MSG_TRACE_DIR, File.separator, n);
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        fileOutputStream.write(byArray);
        if (byArray2 != null) {
            fileOutputStream.write(byArray2);
        }
        fileOutputStream.close();
        string = String.format("%s%s%05d-a-send-message.dat", Config.MSG_TRACE_DIR, File.separator, n);
        fileOutputStream = new FileOutputStream(string);
        fileOutputStream.write(byArray3);
        fileOutputStream.close();
    }

    public static void TraceMessageRecv(int n, byte[] byArray, byte[] byArray2, byte[] byArray3) throws IOException {
        String string = String.format("%s%s%05d-b-recv-header.dat", Config.MSG_TRACE_DIR, File.separator, n);
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        fileOutputStream.write(byArray);
        if (byArray2 != null) {
            fileOutputStream.write(byArray2);
        }
        fileOutputStream.close();
        string = String.format("%s%s%05d-b-recv-message.dat", Config.MSG_TRACE_DIR, File.separator, n);
        fileOutputStream = new FileOutputStream(string);
        fileOutputStream.write(byArray3);
        fileOutputStream.close();
    }
}

