/*
 * Decompiled with CFR 0.152.
 */
package net.razorvine.pickle.objects;

import java.util.ArrayList;
import net.razorvine.pickle.IObjectConstructor;
import net.razorvine.pickle.PickleException;
import net.razorvine.pickle.PickleUtils;

public class ArrayConstructor
implements IObjectConstructor {
    @Override
    public Object construct(Object[] objectArray) throws PickleException {
        if (objectArray.length == 4) {
            ArrayConstructor arrayConstructor = (ArrayConstructor)objectArray[0];
            char c = ((String)objectArray[1]).charAt(0);
            int n = (Integer)objectArray[2];
            byte[] byArray = (byte[])objectArray[3];
            return arrayConstructor.construct(c, n, byArray);
        }
        if (objectArray.length != 2) {
            throw new PickleException("invalid pickle data for array; expected 2 args, got " + objectArray.length);
        }
        String string = (String)objectArray[0];
        ArrayList arrayList = (ArrayList)objectArray[1];
        switch (string.charAt(0)) {
            case 'c': 
            case 'u': {
                char[] cArray = new char[arrayList.size()];
                int n = 0;
                for (Object e : arrayList) {
                    cArray[n++] = ((String)e).charAt(0);
                }
                return cArray;
            }
            case 'b': {
                byte[] byArray = new byte[arrayList.size()];
                int n = 0;
                for (Object e : arrayList) {
                    byArray[n++] = ((Number)e).byteValue();
                }
                return byArray;
            }
            case 'B': 
            case 'h': {
                short[] sArray = new short[arrayList.size()];
                int n = 0;
                for (Object e : arrayList) {
                    sArray[n++] = ((Number)e).shortValue();
                }
                return sArray;
            }
            case 'H': 
            case 'i': 
            case 'l': {
                int[] nArray = new int[arrayList.size()];
                int n = 0;
                for (Object e : arrayList) {
                    nArray[n++] = ((Number)e).intValue();
                }
                return nArray;
            }
            case 'I': 
            case 'L': {
                long[] lArray = new long[arrayList.size()];
                int n = 0;
                for (Object e : arrayList) {
                    lArray[n++] = ((Number)e).longValue();
                }
                return lArray;
            }
            case 'f': {
                float[] fArray = new float[arrayList.size()];
                int n = 0;
                for (Object e : arrayList) {
                    fArray[n++] = ((Number)e).floatValue();
                }
                return fArray;
            }
            case 'd': {
                double[] dArray = new double[arrayList.size()];
                int n = 0;
                for (Object e : arrayList) {
                    dArray[n++] = ((Number)e).doubleValue();
                }
                return dArray;
            }
        }
        throw new PickleException("invalid array typecode: " + string);
    }

    public Object construct(char c, int n, byte[] byArray) throws PickleException {
        if (n < 0) {
            throw new PickleException("unknown machine type format");
        }
        switch (c) {
            case 'c': 
            case 'u': {
                if (n != 18 && n != 19 && n != 20 && n != 21) {
                    throw new PickleException("for c/u type must be 18/19/20/21");
                }
                if (n == 18 || n == 19) {
                    if (byArray.length % 2 != 0) {
                        throw new PickleException("data size alignment error");
                    }
                    return this.constructCharArrayUTF16(n, byArray);
                }
                if (byArray.length % 4 != 0) {
                    throw new PickleException("data size alignment error");
                }
                return this.constructCharArrayUTF32(n, byArray);
            }
            case 'b': {
                if (n != 1) {
                    throw new PickleException("for b type must be 1");
                }
                return byArray;
            }
            case 'B': {
                if (n != 0) {
                    throw new PickleException("for B type must be 0");
                }
                return this.constructShortArrayFromUByte(byArray);
            }
            case 'h': {
                if (n != 4 && n != 5) {
                    throw new PickleException("for h type must be 4/5");
                }
                if (byArray.length % 2 != 0) {
                    throw new PickleException("data size alignment error");
                }
                return this.constructShortArraySigned(n, byArray);
            }
            case 'H': {
                if (n != 2 && n != 3) {
                    throw new PickleException("for H type must be 2/3");
                }
                if (byArray.length % 2 != 0) {
                    throw new PickleException("data size alignment error");
                }
                return this.constructIntArrayFromUShort(n, byArray);
            }
            case 'i': {
                if (n != 8 && n != 9) {
                    throw new PickleException("for i type must be 8/9");
                }
                if (byArray.length % 4 != 0) {
                    throw new PickleException("data size alignment error");
                }
                return this.constructIntArrayFromInt32(n, byArray);
            }
            case 'l': {
                if (n != 8 && n != 9 && n != 12 && n != 13) {
                    throw new PickleException("for l type must be 8/9/12/13");
                }
                if ((n == 8 || n == 9) && byArray.length % 4 != 0) {
                    throw new PickleException("data size alignment error");
                }
                if ((n == 12 || n == 13) && byArray.length % 8 != 0) {
                    throw new PickleException("data size alignment error");
                }
                if (n == 8 || n == 9) {
                    return this.constructIntArrayFromInt32(n, byArray);
                }
                return this.constructLongArrayFromInt64(n, byArray);
            }
            case 'I': {
                if (n != 6 && n != 7) {
                    throw new PickleException("for I type must be 6/7");
                }
                if (byArray.length % 4 != 0) {
                    throw new PickleException("data size alignment error");
                }
                return this.constructLongArrayFromUInt32(n, byArray);
            }
            case 'L': {
                if (n != 6 && n != 7 && n != 10 && n != 11) {
                    throw new PickleException("for L type must be 6/7/10/11");
                }
                if ((n == 6 || n == 7) && byArray.length % 4 != 0) {
                    throw new PickleException("data size alignment error");
                }
                if ((n == 10 || n == 11) && byArray.length % 8 != 0) {
                    throw new PickleException("data size alignment error");
                }
                if (n == 6 || n == 7) {
                    return this.constructLongArrayFromUInt32(n, byArray);
                }
                return this.constructLongArrayFromUInt64(n, byArray);
            }
            case 'f': {
                if (n != 14 && n != 15) {
                    throw new PickleException("for f type must be 14/15");
                }
                if (byArray.length % 4 != 0) {
                    throw new PickleException("data size alignment error");
                }
                return this.constructFloatArray(n, byArray);
            }
            case 'd': {
                if (n != 16 && n != 17) {
                    throw new PickleException("for d type must be 16/17");
                }
                if (byArray.length % 8 != 0) {
                    throw new PickleException("data size alignment error");
                }
                return this.constructDoubleArray(n, byArray);
            }
        }
        throw new PickleException("invalid array typecode: " + c);
    }

    protected int[] constructIntArrayFromInt32(int n, byte[] byArray) {
        int[] nArray = new int[byArray.length / 4];
        byte[] byArray2 = new byte[4];
        for (int i = 0; i < byArray.length / 4; ++i) {
            if (n == 8) {
                nArray[i] = PickleUtils.bytes_to_integer(byArray, i * 4, 4);
                continue;
            }
            byArray2[0] = byArray[3 + i * 4];
            byArray2[1] = byArray[2 + i * 4];
            byArray2[2] = byArray[1 + i * 4];
            byArray2[3] = byArray[0 + i * 4];
            nArray[i] = PickleUtils.bytes_to_integer(byArray2);
        }
        return nArray;
    }

    protected long[] constructLongArrayFromUInt32(int n, byte[] byArray) {
        long[] lArray = new long[byArray.length / 4];
        byte[] byArray2 = new byte[4];
        for (int i = 0; i < byArray.length / 4; ++i) {
            if (n == 6) {
                lArray[i] = PickleUtils.bytes_to_uint(byArray, i * 4);
                continue;
            }
            byArray2[0] = byArray[3 + i * 4];
            byArray2[1] = byArray[2 + i * 4];
            byArray2[2] = byArray[1 + i * 4];
            byArray2[3] = byArray[0 + i * 4];
            lArray[i] = PickleUtils.bytes_to_uint(byArray2, 0);
        }
        return lArray;
    }

    protected long[] constructLongArrayFromUInt64(int n, byte[] byArray) {
        throw new PickleException("unsupported datatype: 64-bits unsigned long");
    }

    protected long[] constructLongArrayFromInt64(int n, byte[] byArray) {
        long[] lArray = new long[byArray.length / 8];
        byte[] byArray2 = new byte[8];
        for (int i = 0; i < byArray.length / 8; ++i) {
            if (n == 12) {
                lArray[i] = PickleUtils.bytes_to_long(byArray, i * 8);
                continue;
            }
            byArray2[0] = byArray[7 + i * 8];
            byArray2[1] = byArray[6 + i * 8];
            byArray2[2] = byArray[5 + i * 8];
            byArray2[3] = byArray[4 + i * 8];
            byArray2[4] = byArray[3 + i * 8];
            byArray2[5] = byArray[2 + i * 8];
            byArray2[6] = byArray[1 + i * 8];
            byArray2[7] = byArray[0 + i * 8];
            lArray[i] = PickleUtils.bytes_to_long(byArray2, 0);
        }
        return lArray;
    }

    protected double[] constructDoubleArray(int n, byte[] byArray) {
        double[] dArray = new double[byArray.length / 8];
        byte[] byArray2 = new byte[8];
        for (int i = 0; i < byArray.length / 8; ++i) {
            if (n == 16) {
                dArray[i] = PickleUtils.bytes_to_double(byArray, i * 8);
                continue;
            }
            byArray2[0] = byArray[7 + i * 8];
            byArray2[1] = byArray[6 + i * 8];
            byArray2[2] = byArray[5 + i * 8];
            byArray2[3] = byArray[4 + i * 8];
            byArray2[4] = byArray[3 + i * 8];
            byArray2[5] = byArray[2 + i * 8];
            byArray2[6] = byArray[1 + i * 8];
            byArray2[7] = byArray[0 + i * 8];
            dArray[i] = PickleUtils.bytes_to_double(byArray2, 0);
        }
        return dArray;
    }

    protected float[] constructFloatArray(int n, byte[] byArray) {
        float[] fArray = new float[byArray.length / 4];
        byte[] byArray2 = new byte[4];
        for (int i = 0; i < byArray.length / 4; ++i) {
            if (n == 14) {
                fArray[i] = PickleUtils.bytes_to_float(byArray, i * 4);
                continue;
            }
            byArray2[0] = byArray[3 + i * 4];
            byArray2[1] = byArray[2 + i * 4];
            byArray2[2] = byArray[1 + i * 4];
            byArray2[3] = byArray[0 + i * 4];
            fArray[i] = PickleUtils.bytes_to_float(byArray2, 0);
        }
        return fArray;
    }

    protected int[] constructIntArrayFromUShort(int n, byte[] byArray) {
        int[] nArray = new int[byArray.length / 2];
        for (int i = 0; i < byArray.length / 2; ++i) {
            int n2 = byArray[0 + i * 2] & 0xFF;
            int n3 = byArray[1 + i * 2] & 0xFF;
            nArray[i] = n == 2 ? n3 << 8 | n2 : n2 << 8 | n3;
        }
        return nArray;
    }

    protected short[] constructShortArraySigned(int n, byte[] byArray) {
        short[] sArray = new short[byArray.length / 2];
        for (int i = 0; i < byArray.length / 2; ++i) {
            byte by = byArray[0 + i * 2];
            byte by2 = byArray[1 + i * 2];
            sArray[i] = n == 4 ? (short)(by2 << 8 | by & 0xFF) : (short)(by << 8 | by2 & 0xFF);
        }
        return sArray;
    }

    protected short[] constructShortArrayFromUByte(byte[] byArray) {
        short[] sArray = new short[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            sArray[i] = (short)(byArray[i] & 0xFF);
        }
        return sArray;
    }

    protected char[] constructCharArrayUTF32(int n, byte[] byArray) {
        char[] cArray = new char[byArray.length / 4];
        byte[] byArray2 = new byte[4];
        for (int i = 0; i < byArray.length / 4; ++i) {
            char[] cArray2;
            int n2;
            if (n == 20) {
                n2 = PickleUtils.bytes_to_integer(byArray, i * 4, 4);
                cArray2 = Character.toChars(n2);
                if (cArray2.length > 1) {
                    throw new PickleException("cannot process UTF-32 character codepoint " + n2);
                }
                cArray[i] = cArray2[0];
                continue;
            }
            byArray2[0] = byArray[3 + i * 4];
            byArray2[1] = byArray[2 + i * 4];
            byArray2[2] = byArray[1 + i * 4];
            byArray2[3] = byArray[i * 4];
            n2 = PickleUtils.bytes_to_integer(byArray2);
            cArray2 = Character.toChars(n2);
            if (cArray2.length > 1) {
                throw new PickleException("cannot process UTF-32 character codepoint " + n2);
            }
            cArray[i] = cArray2[0];
        }
        return cArray;
    }

    protected char[] constructCharArrayUTF16(int n, byte[] byArray) {
        char[] cArray = new char[byArray.length / 2];
        byte[] byArray2 = new byte[2];
        for (int i = 0; i < byArray.length / 2; ++i) {
            if (n == 18) {
                cArray[i] = (char)PickleUtils.bytes_to_integer(byArray, i * 2, 2);
                continue;
            }
            byArray2[0] = byArray[1 + i * 2];
            byArray2[1] = byArray[0 + i * 2];
            cArray[i] = (char)PickleUtils.bytes_to_integer(byArray2);
        }
        return cArray;
    }
}

