/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorSerializeRowNoNulls;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerBigOnlyGenerateResultOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinBytesHashMultiSet;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableSerializeWrite;

public class VectorMapJoinInnerBigOnlyMultiKeyOperator
extends VectorMapJoinInnerBigOnlyGenerateResultOperator {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog((String)VectorMapJoinInnerBigOnlyMultiKeyOperator.class.getName());
    private static final String CLASS_NAME = VectorMapJoinInnerBigOnlyMultiKeyOperator.class.getName();
    private transient VectorMapJoinBytesHashMultiSet hashMultiSet;
    private transient VectorSerializeRowNoNulls keyVectorSerializeWriteNoNulls;
    private transient ByteStream.Output currentKeyOutput;
    private transient ByteStream.Output saveKeyOutput;

    public VectorMapJoinInnerBigOnlyMultiKeyOperator() {
    }

    public VectorMapJoinInnerBigOnlyMultiKeyOperator(VectorizationContext vContext, OperatorDesc conf) throws HiveException {
        super(vContext, conf);
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        try {
            boolean allKeyInputColumnsRepeating;
            VectorizedRowBatch batch = (VectorizedRowBatch)row;
            this.alias = (byte)tag;
            if (this.needCommonSetup) {
                this.commonSetup(batch);
                this.keyVectorSerializeWriteNoNulls = new VectorSerializeRowNoNulls(new BinarySortableSerializeWrite(this.bigTableKeyColumnMap.length));
                this.keyVectorSerializeWriteNoNulls.init(this.bigTableKeyTypeNames, this.bigTableKeyColumnMap);
                this.currentKeyOutput = new ByteStream.Output();
                this.saveKeyOutput = new ByteStream.Output();
                this.needCommonSetup = false;
            }
            if (this.needHashTableSetup) {
                this.hashMultiSet = (VectorMapJoinBytesHashMultiSet)this.vectorMapJoinHashTable;
                this.needHashTableSetup = false;
            }
            ++this.batchCounter;
            for (VectorExpression ve : this.bigTableFilterExpressions) {
                ve.evaluate(batch);
            }
            int inputLogicalSize = batch.size;
            if (inputLogicalSize == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(CLASS_NAME + " batch #" + this.batchCounter + " empty"));
                }
                return;
            }
            if (this.bigTableKeyExpressions != null) {
                for (VectorExpression ve : this.bigTableKeyExpressions) {
                    ve.evaluate(batch);
                }
            }
            if (this.bigTableKeyColumnMap.length == 0) {
                allKeyInputColumnsRepeating = false;
            } else {
                allKeyInputColumnsRepeating = true;
                for (int i = 0; i < this.bigTableKeyColumnMap.length; ++i) {
                    if (batch.cols[this.bigTableKeyColumnMap[i]].isRepeating) continue;
                    allKeyInputColumnsRepeating = false;
                    break;
                }
            }
            if (allKeyInputColumnsRepeating) {
                this.keyVectorSerializeWriteNoNulls.setOutput(this.currentKeyOutput);
                this.keyVectorSerializeWriteNoNulls.serializeWriteNoNulls(batch, 0);
                byte[] keyBytes = this.currentKeyOutput.getData();
                int keyLength = this.currentKeyOutput.getLength();
                JoinUtil.JoinResult joinResult = this.hashMultiSet.contains(keyBytes, 0, keyLength, this.hashMultiSetResults[0]);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(CLASS_NAME + " batch #" + this.batchCounter + " repeated joinResult " + joinResult.name()));
                }
                this.finishInnerBigOnlyRepeated(batch, joinResult, this.hashMultiSetResults[0]);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(CLASS_NAME + " batch #" + this.batchCounter + " non-repeated"));
                }
                int[] selected = batch.selected;
                boolean selectedInUse = batch.selectedInUse;
                int hashMultiSetResultCount = 0;
                int allMatchCount = 0;
                int equalKeySeriesCount = 0;
                int spillCount = 0;
                boolean haveSaveKey = false;
                JoinUtil.JoinResult saveJoinResult = JoinUtil.JoinResult.NOMATCH;
                block22: for (int logical = 0; logical < inputLogicalSize; ++logical) {
                    int batchIndex = selectedInUse ? selected[logical] : logical;
                    this.keyVectorSerializeWriteNoNulls.setOutput(this.currentKeyOutput);
                    this.keyVectorSerializeWriteNoNulls.serializeWriteNoNulls(batch, batchIndex);
                    if (!haveSaveKey || !this.saveKeyOutput.arraysEquals(this.currentKeyOutput)) {
                        if (haveSaveKey) {
                            switch (saveJoinResult) {
                                case MATCH: {
                                    ++equalKeySeriesCount;
                                    break;
                                }
                                case SPILL: {
                                    ++hashMultiSetResultCount;
                                    break;
                                }
                            }
                        }
                        haveSaveKey = true;
                        ByteStream.Output temp = this.saveKeyOutput;
                        this.saveKeyOutput = this.currentKeyOutput;
                        this.currentKeyOutput = temp;
                        byte[] keyBytes = this.saveKeyOutput.getData();
                        int keyLength = this.saveKeyOutput.getLength();
                        saveJoinResult = this.hashMultiSet.contains(keyBytes, 0, keyLength, this.hashMultiSetResults[hashMultiSetResultCount]);
                        switch (saveJoinResult) {
                            case MATCH: {
                                this.equalKeySeriesValueCounts[equalKeySeriesCount] = this.hashMultiSetResults[hashMultiSetResultCount].count();
                                this.equalKeySeriesAllMatchIndices[equalKeySeriesCount] = allMatchCount;
                                this.equalKeySeriesDuplicateCounts[equalKeySeriesCount] = 1;
                                this.allMatchs[allMatchCount++] = batchIndex;
                                break;
                            }
                            case SPILL: {
                                this.spills[spillCount] = batchIndex;
                                this.spillHashMapResultIndices[spillCount] = hashMultiSetResultCount;
                                ++spillCount;
                                break;
                            }
                        }
                        continue;
                    }
                    switch (saveJoinResult) {
                        case MATCH: {
                            int n = equalKeySeriesCount;
                            this.equalKeySeriesDuplicateCounts[n] = this.equalKeySeriesDuplicateCounts[n] + 1;
                            this.allMatchs[allMatchCount++] = batchIndex;
                            continue block22;
                        }
                        case SPILL: {
                            this.spills[spillCount] = batchIndex;
                            this.spillHashMapResultIndices[spillCount] = hashMultiSetResultCount;
                            ++spillCount;
                            continue block22;
                        }
                    }
                }
                if (haveSaveKey) {
                    switch (saveJoinResult) {
                        case MATCH: {
                            ++equalKeySeriesCount;
                            break;
                        }
                        case SPILL: {
                            ++hashMultiSetResultCount;
                            break;
                        }
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(CLASS_NAME + " allMatchs " + VectorMapJoinInnerBigOnlyMultiKeyOperator.intArrayToRangesString(this.allMatchs, allMatchCount) + " equalKeySeriesValueCounts " + VectorMapJoinInnerBigOnlyMultiKeyOperator.longArrayToRangesString(this.equalKeySeriesValueCounts, equalKeySeriesCount) + " equalKeySeriesAllMatchIndices " + VectorMapJoinInnerBigOnlyMultiKeyOperator.intArrayToRangesString(this.equalKeySeriesAllMatchIndices, equalKeySeriesCount) + " equalKeySeriesDuplicateCounts " + VectorMapJoinInnerBigOnlyMultiKeyOperator.intArrayToRangesString(this.equalKeySeriesDuplicateCounts, equalKeySeriesCount) + " spills " + VectorMapJoinInnerBigOnlyMultiKeyOperator.intArrayToRangesString(this.spills, spillCount) + " spillHashMapResultIndices " + VectorMapJoinInnerBigOnlyMultiKeyOperator.intArrayToRangesString(this.spillHashMapResultIndices, spillCount) + " hashMapResults " + Arrays.toString(Arrays.copyOfRange(this.hashMultiSetResults, 0, hashMultiSetResultCount))));
                }
                this.finishInnerBigOnly(batch, allMatchCount, equalKeySeriesCount, spillCount, this.hashMultiSetResults, hashMultiSetResultCount);
            }
            if (batch.size > 0) {
                this.forwardBigTableBatch(batch);
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }
}

