/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.kafka.connect.apiclient;

import java.io.File;
import java.util.Objects;

public final class Configuration {
    private final String apiHost;
    private int requestTimeoutInSeconds = 300;
    private String basicAuthUsername = null;
    private String basicAuthPassword = null;
    private boolean ignoreInvalidSslCertificates = false;
    private File trustStoreFile = null;
    private String trustStorePassword = null;
    private File keyStoreFile = null;
    private String keyStorePassword = null;
    private String proxyHost = null;
    private int proxyPort = 0;
    private String proxyScheme = "HTTP";
    private String proxyUsername = null;
    private String proxyPassword = null;

    public Configuration(String kafkaConnectHost) {
        if (kafkaConnectHost == null) {
            throw new NullPointerException("Kafka Connect Host parameter cannot be null!");
        }
        this.apiHost = kafkaConnectHost.startsWith("http://") || kafkaConnectHost.startsWith("https://") ? kafkaConnectHost : "http://" + kafkaConnectHost;
    }

    public Configuration useBasicAuth(String username, String password) {
        this.basicAuthUsername = username;
        this.basicAuthPassword = password;
        return this;
    }

    public Configuration useProxy(String proxyHost, int proxyPort, String proxyScheme) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyScheme = proxyScheme;
        return this;
    }

    public Configuration useProxyAuthentication(String proxyUsername, String proxyPassword) {
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        return this;
    }

    public Configuration useInsecureSslCertificates() {
        this.ignoreInvalidSslCertificates = true;
        return this;
    }

    public Configuration useTrustStore(File trustStoreFile, String password) {
        this.trustStoreFile = Objects.requireNonNull(trustStoreFile);
        this.trustStorePassword = password;
        return this;
    }

    public Configuration useKeyStore(File keyStoreFile, String password) {
        this.keyStoreFile = Objects.requireNonNull(keyStoreFile);
        this.keyStorePassword = password;
        return this;
    }

    public Configuration useRequestTimeoutInSeconds(int requestTimeoutInSeconds) {
        this.requestTimeoutInSeconds = requestTimeoutInSeconds;
        return this;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyScheme() {
        return this.proxyScheme;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public String getApiHost() {
        return this.apiHost;
    }

    public boolean getIgnoreInvalidSslCertificates() {
        return this.ignoreInvalidSslCertificates;
    }

    public File getTrustStoreFile() {
        return this.trustStoreFile;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public int getRequestTimeoutInSeconds() {
        return this.requestTimeoutInSeconds;
    }

    public File getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public String getBasicAuthUsername() {
        return this.basicAuthUsername;
    }

    public String getBasicAuthPassword() {
        return this.basicAuthPassword;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Configuration{").append("apiHost='").append(this.apiHost).append('\'').append(", requestTimeout='").append(this.requestTimeoutInSeconds).append('\'');
        if (this.proxyHost != null) {
            stringBuilder.append(", proxy='").append(this.proxyScheme).append("://");
            if (this.proxyUsername != null) {
                stringBuilder.append(this.proxyUsername).append(':').append("XXXXXXX@");
            }
            stringBuilder.append(this.proxyHost).append(":").append(this.proxyPort).append('\'');
        }
        stringBuilder.append(", ignoreInvalidSslCertificates='").append(this.ignoreInvalidSslCertificates).append('\'');
        if (this.trustStoreFile != null) {
            stringBuilder.append(", sslTrustStoreFile='").append(this.trustStoreFile).append('\'');
            if (this.trustStorePassword != null) {
                stringBuilder.append(", sslTrustStorePassword='******'");
            }
        }
        if (this.basicAuthUsername != null) {
            stringBuilder.append(", basicAuthUsername='").append(this.basicAuthUsername).append('\'').append(", basicAuthPassword='******'");
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

