/*
 * Decompiled with CFR 0.152.
 */
package org.sourcei.android.permissions.handlers;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.RequiresApi;
import android.support.v4.content.PermissionChecker;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.sourcei.android.permissions.utils.C;
import org.sourcei.android.permissions.utils.Config;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0011B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u001c\u0010\f\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\t0\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\u0012"}, d2={"Lorg/sourcei/android/permissions/handlers/PermissionsHandler;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "setContext", "askPermission", "", "permission", "", "callback", "Lkotlin/Function2;", "isPermissionAvailable", "", "isPermissionProvidedInManifest", "Inner", "permissions_release"})
public final class PermissionsHandler {
    @NotNull
    public Context context;

    @NotNull
    public final Context getContext() {
        Context context = this.context;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
        }
        return context;
    }

    public final void setContext(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"<set-?>");
        this.context = context;
    }

    public final boolean isPermissionAvailable(@NotNull String permission) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        if (this.isPermissionProvidedInManifest(permission)) {
            if (Build.VERSION.SDK_INT < 23) {
                bl = true;
            } else {
                Context context = this.context;
                if (context == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"context");
                }
                bl = PermissionChecker.checkSelfPermission((Context)context, (String)permission) == 0;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public final void askPermission(@NotNull String permission, @NotNull Function2<Object, Object, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        if (this.isPermissionProvidedInManifest(permission)) {
            if (this.isPermissionAvailable(permission)) {
                callback.invoke(null, (Object)true);
            } else {
                Context context = this.context;
                if (context == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"context");
                }
                Intent intent = new Intent(context, Inner.class);
                intent.putExtra(C.INSTANCE.getPERMISSION(), permission);
                Config.INSTANCE.setCallback(callback);
                Context context2 = this.context;
                if (context2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"context");
                }
                if (context2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.support.v7.app.AppCompatActivity");
                }
                ((AppCompatActivity)context2).startActivity(intent);
            }
        } else {
            callback.invoke((Object)false, null);
        }
    }

    private final boolean isPermissionProvidedInManifest(String permission) {
        String NAME = "Permissions";
        try {
            PackageInfo packageInfo;
            Context context = this.context;
            if (context == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            }
            PackageManager packageManager = context.getPackageManager();
            Context context2 = this.context;
            if (context2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            }
            if ((packageInfo = packageManager.getPackageInfo(context2.getPackageName(), 4096)) != null) {
                boolean bl;
                Object[] objectArray;
                Object[] requestedPermissions = packageInfo.requestedPermissions;
                if (requestedPermissions == null || (objectArray = requestedPermissions).length == 0) {
                    Log.d((String)NAME, (String)"No permissions provided in Manifest");
                    bl = false;
                } else if (ArraysKt.contains((Object[])requestedPermissions, (Object)permission)) {
                    bl = true;
                } else {
                    Log.d((String)NAME, (String)('[' + permission + "] not provided in Manifest"));
                    bl = false;
                }
                return bl;
            }
            Log.d((String)"Permissions", (String)" Package info not available");
            return false;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public PermissionsHandler(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0015J-\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00042\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/sourcei/android/permissions/handlers/PermissionsHandler$Inner;", "Landroid/support/v7/app/AppCompatActivity;", "()V", "PERMISSION_REQUEST_CODE", "", "onBackPressed", "", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onRequestPermissionsResult", "requestCode", "permissions", "", "", "grantResults", "", "(I[Ljava/lang/String;[I)V", "permissions_release"})
    public static final class Inner
    extends AppCompatActivity {
        private final int PERMISSION_REQUEST_CODE = 1;

        @RequiresApi(value=23)
        protected void onCreate(@Nullable Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            Intent intent = this.getIntent();
            Intrinsics.checkExpressionValueIsNotNull((Object)intent, (String)"intent");
            Object object = intent.getExtras().get(C.INSTANCE.getPERMISSION());
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            String permission = (String)object;
            this.requestPermissions(new String[]{permission}, this.PERMISSION_REQUEST_CODE);
        }

        public void onRequestPermissionsResult(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
            Intrinsics.checkParameterIsNotNull((Object)permissions, (String)"permissions");
            Intrinsics.checkParameterIsNotNull((Object)grantResults, (String)"grantResults");
            super.onRequestPermissionsResult(requestCode, permissions, grantResults);
            if (requestCode == this.PERMISSION_REQUEST_CODE) {
                int[] nArray = grantResults;
                int[] nArray2 = nArray;
                if (!(nArray2.length == 0)) {
                    if (grantResults[0] == 0) {
                        Config.INSTANCE.getCallback().invoke(null, (Object)true);
                    } else {
                        Config.INSTANCE.getCallback().invoke((Object)false, null);
                    }
                } else {
                    Config.INSTANCE.getCallback().invoke((Object)false, null);
                }
                this.finish();
            }
        }

        public void onBackPressed() {
            Config.INSTANCE.getCallback().invoke((Object)false, null);
            this.finish();
        }
    }
}

