/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

class SSLSocketFactoryWrapper
extends SSLSocketFactory {
    private final SSLSocketFactory delegate;
    private final SSLParameters parameters;

    public SSLSocketFactoryWrapper(SSLSocketFactory delegate, SSLParameters parameters) {
        this.delegate = delegate;
        this.parameters = parameters;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.delegate.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.delegate.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        SSLSocket sslSocket = (SSLSocket)this.delegate.createSocket(socket, host, port, autoClose);
        sslSocket.setSSLParameters(this.parameters);
        return sslSocket;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        SSLSocket socket = (SSLSocket)this.delegate.createSocket(host, port);
        socket.setSSLParameters(this.parameters);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
        SSLSocket socket = (SSLSocket)this.delegate.createSocket(host, port, localAddress, localPort);
        socket.setSSLParameters(this.parameters);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress address, int port) throws IOException {
        SSLSocket socket = (SSLSocket)this.delegate.createSocket(address, port);
        socket.setSSLParameters(this.parameters);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        SSLSocket socket = (SSLSocket)this.delegate.createSocket(address, port, localAddress, localPort);
        socket.setSSLParameters(this.parameters);
        return socket;
    }
}

