/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.cas.undertow;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import org.soulwing.cas.service.AuthenticationService;
import org.soulwing.cas.service.ProxyCallbackResponse;
import org.soulwing.cas.undertow.UndertowLogger;

public class ProxyCallbackHttpHandler
implements HttpHandler {
    private final HttpHandler next;
    private final AuthenticationService authenticationService;

    public ProxyCallbackHttpHandler(HttpHandler next, AuthenticationService authenticationService) {
        this.next = next;
        this.authenticationService = authenticationService;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (this.authenticationService.isProxyCallbackPath(exchange.getRelativePath())) {
            if (exchange.isInIoThread()) {
                exchange.dispatch((HttpHandler)this);
                return;
            }
            if (UndertowLogger.LOGGER.isDebugEnabled()) {
                UndertowLogger.LOGGER.debug((Object)("proxy callback: " + exchange.getRequestMethod() + " " + exchange.getRequestURL() + "?" + exchange.getQueryString() + " (content-length=" + exchange.getRequestContentLength() + " content-type=" + exchange.getRequestHeaders().get(Headers.CONTENT_TYPE, 0) + ")"));
            }
            ProxyCallbackResponse response = this.authenticationService.handleProxyCallback(exchange.getQueryString());
            String message = response.getMessage();
            exchange.setResponseCode(response.getStatus());
            if (message.isEmpty()) {
                exchange.setResponseContentLength(0L);
            } else {
                exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/plain; charset=UTF-8");
                exchange.getResponseSender().send(message + "\r\n");
            }
            exchange.endExchange();
            return;
        }
        this.next.handleRequest(exchange);
    }
}

