/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.cas.undertow;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HttpString;
import org.soulwing.cas.service.Authenticator;
import org.soulwing.cas.undertow.CasAttachments;
import org.soulwing.cas.undertow.UndertowLogger;

public class PostAuthRedirectHttpHandler
implements HttpHandler {
    private final HttpHandler next;

    public PostAuthRedirectHttpHandler(HttpHandler next) {
        this.next = next;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        boolean wantsRedirect;
        Authenticator authenticator = (Authenticator)exchange.getAttachment(CasAttachments.AUTHENTICATOR_KEY);
        boolean bl = wantsRedirect = exchange.getAttachment(CasAttachments.POST_AUTH_REDIRECT_KEY) != null;
        if (authenticator != null && wantsRedirect) {
            exchange.removeAttachment(CasAttachments.POST_AUTH_REDIRECT_KEY);
            UndertowLogger.LOGGER.debug((Object)"found post auth redirect key");
            String url = authenticator.postAuthUrl(exchange.getRequestURL(), exchange.getQueryString());
            UndertowLogger.LOGGER.debug((Object)("sending redirect to " + url));
            exchange.setResponseCode(302);
            exchange.getResponseHeaders().put(HttpString.tryFromString((String)"Location"), url);
            exchange.endExchange();
            return;
        }
        this.next.handleRequest(exchange);
    }
}

