/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.cas.undertow;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.api.DeploymentInfo;
import javax.servlet.ServletContext;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.AbstractService;
import org.soulwing.cas.service.AuthenticationService;
import org.soulwing.cas.undertow.CasAuthenticationMechanism;
import org.soulwing.cas.undertow.CasAuthenticationService;
import org.soulwing.cas.undertow.PostAuthRedirectHttpHandler;
import org.soulwing.cas.undertow.ProxyCallbackHttpHandler;

public class CasServletExtension
extends AbstractService<ServletExtension>
implements ServletExtension {
    private final CasAuthenticationService authenticationService = new CasAuthenticationService();

    public Injector<AuthenticationService> getAuthenticationServiceInjector() {
        return this.authenticationService.getServiceInjector();
    }

    public void handleDeployment(DeploymentInfo deploymentInfo, ServletContext servletContext) {
        deploymentInfo.clearLoginMethods();
        deploymentInfo.addFirstAuthenticationMechanism("CAS", (AuthenticationMechanism)new CasAuthenticationMechanism(deploymentInfo.getContextPath(), this.authenticationService));
        deploymentInfo.addInitialHandlerChainWrapper(new HandlerWrapper(){

            public HttpHandler wrap(HttpHandler handler) {
                return new ProxyCallbackHttpHandler(handler, CasServletExtension.this.authenticationService);
            }
        });
        deploymentInfo.addInnerHandlerChainWrapper(new HandlerWrapper(){

            public HttpHandler wrap(HttpHandler handler) {
                return new PostAuthRedirectHttpHandler(handler);
            }
        });
    }
}

