/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.cas.undertow;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.util.HttpString;
import org.soulwing.cas.api.IdentityAssertion;
import org.soulwing.cas.service.AuthenticationException;
import org.soulwing.cas.service.Authenticator;
import org.soulwing.cas.service.NoTicketException;
import org.soulwing.cas.undertow.AuthorizationException;
import org.soulwing.cas.undertow.CasAttachments;
import org.soulwing.cas.undertow.CasAuthenticationService;
import org.soulwing.cas.undertow.IdentityAssertionCredential;
import org.soulwing.cas.undertow.UndertowLogger;

public class CasAuthenticationMechanism
implements AuthenticationMechanism {
    public static final String MECHANISM_NAME = "CAS";
    public static final String NOT_AUTHORIZED_MESSAGE = "identity manager does not recognize user '%s'";
    public static final String STATUS_COOKIE = "cas-status";
    public static final int MAX_RETRIES = 2;
    private final String contextPath;
    private final CasAuthenticationService authenticationService;

    public CasAuthenticationMechanism(String contextPath, CasAuthenticationService authenticationService) {
        this.contextPath = contextPath;
        this.authenticationService = authenticationService;
    }

    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        if (!securityContext.isAuthenticationRequired()) {
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
        }
        Authenticator authenticator = this.authenticationService.newAuthenticator(this.contextPath);
        exchange.putAttachment(CasAttachments.AUTHENTICATOR_KEY, (Object)authenticator);
        try {
            IdentityAssertion assertion = authenticator.validateTicket(exchange.getRequestPath(), exchange.getQueryString());
            IdentityAssertionCredential credential = new IdentityAssertionCredential(assertion);
            Account account = this.authorize(credential, securityContext);
            this.resetRetryCount(exchange);
            exchange.putAttachment(CasAttachments.CREDENTIAL_KEY, (Object)credential);
            if (authenticator.isPostAuthRedirect()) {
                exchange.putAttachment(CasAttachments.POST_AUTH_REDIRECT_KEY, (Object)true);
            }
            securityContext.authenticationComplete(account, MECHANISM_NAME, true);
            return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
        }
        catch (NoTicketException ex) {
            if (UndertowLogger.LOGGER.isDebugEnabled()) {
                UndertowLogger.LOGGER.debug((Object)"no ticket present; authentication not attempted");
            }
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
        }
        catch (AuthorizationException ex) {
            exchange.putAttachment(CasAttachments.AUTH_FAILED_KEY, (Object)403);
            securityContext.authenticationFailed(ex.getMessage(), MECHANISM_NAME);
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        catch (RuntimeException | AuthenticationException ex) {
            if (UndertowLogger.LOGGER.isDebugEnabled()) {
                UndertowLogger.LOGGER.debug((Object)("authentication failed: " + ex.getMessage()));
            }
            securityContext.setAuthenticationRequired();
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
    }

    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext context) {
        Integer failedStatus = (Integer)exchange.getAttachment(CasAttachments.AUTH_FAILED_KEY);
        if (failedStatus != null) {
            exchange.removeAttachment(CasAttachments.AUTH_FAILED_KEY);
            this.resetRetryCount(exchange);
            return new AuthenticationMechanism.ChallengeResult(false, failedStatus);
        }
        if (this.getRetryCount(exchange) >= 2) {
            if (UndertowLogger.LOGGER.isDebugEnabled()) {
                UndertowLogger.LOGGER.debug((Object)"authentication failed: too many retries");
            }
            this.resetRetryCount(exchange);
            return new AuthenticationMechanism.ChallengeResult(false, Integer.valueOf(401));
        }
        Authenticator authenticator = (Authenticator)exchange.getAttachment(CasAttachments.AUTHENTICATOR_KEY);
        String url = authenticator.loginUrl(exchange.getRequestPath(), exchange.getQueryString());
        if (UndertowLogger.LOGGER.isDebugEnabled()) {
            UndertowLogger.LOGGER.debug((Object)("responding with redirect to '" + url + "'"));
        }
        exchange.getResponseHeaders().put(HttpString.tryFromString((String)"Location"), url);
        return new AuthenticationMechanism.ChallengeResult(true, Integer.valueOf(302));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getRetryCount(HttpServerExchange exchange) {
        int retries = 0;
        Cookie cookie = (Cookie)exchange.getRequestCookies().get(STATUS_COOKIE);
        if (cookie == null) {
            cookie = this.newCookie();
        } else {
            try {
                String value = cookie.getValue();
                retries = Integer.parseInt(value) + 1;
                if (retries < 0 || retries > 2) {
                    retries = 2;
                }
            }
            catch (NumberFormatException ex) {
                retries = 2;
            }
            finally {
                cookie.setValue(Integer.toString(retries));
            }
        }
        cookie.setHttpOnly(true);
        cookie.setSecure(true);
        exchange.getResponseCookies().put(STATUS_COOKIE, cookie);
        return retries;
    }

    private void resetRetryCount(HttpServerExchange exchange) {
        Cookie cookie = this.newCookie();
        cookie.setValue("-1");
        exchange.getResponseCookies().put(STATUS_COOKIE, cookie);
    }

    private Cookie newCookie() {
        CookieImpl cookie = new CookieImpl(STATUS_COOKIE, "0");
        cookie.setHttpOnly(true);
        cookie.setSecure(true);
        return cookie;
    }

    private Account authorize(IdentityAssertionCredential credential, SecurityContext securityContext) throws AuthorizationException {
        String name = credential.getIdentityAssertion().getPrincipal().getName();
        Account account = securityContext.getIdentityManager().verify(name, (Credential)credential);
        if (account == null) {
            String message = String.format(NOT_AUTHORIZED_MESSAGE, name);
            if (UndertowLogger.LOGGER.isDebugEnabled()) {
                UndertowLogger.LOGGER.debug((Object)message);
            }
            throw new AuthorizationException(message);
        }
        if (UndertowLogger.LOGGER.isDebugEnabled()) {
            UndertowLogger.LOGGER.debug((Object)("authorization successful:  user=" + account.getPrincipal().getName() + " roles=" + account.getRoles()));
        }
        return account;
    }
}

