/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.cas.transformer;

import java.util.Properties;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.soulwing.cas.api.AttributeTransformer;
import org.soulwing.cas.api.Transformer;
import org.soulwing.cas.transformer.TransformerLoadException;
import org.soulwing.cas.transformer.TransformerLogger;

public class TransformerFactory {
    public static Transformer<?, ?> getTransformer(String code, String moduleSpec, Properties properties) throws TransformerLoadException {
        if (code == null) {
            throw new TransformerLoadException("transformer class name is required");
        }
        Class<?> transformerClass = null;
        ModuleIdentifier moduleId = TransformerFactory.moduleId(moduleSpec);
        try {
            transformerClass = TransformerFactory.loadTransformerClass(code, moduleId);
            Object transformer = transformerClass.newInstance();
            if (transformer instanceof AttributeTransformer) {
                ((AttributeTransformer)transformer).initialize(properties);
            } else if (!(transformer instanceof Transformer)) {
                throw new IllegalArgumentException("not a transformer object");
            }
            TransformerLogger.LOGGER.debug((Object)("loaded transformer " + transformerClass));
            return (Transformer)transformer;
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new TransformerLoadException("cannot instantiate transformer class " + transformerClass, ex);
        }
        catch (ClassNotFoundException ex) {
            throw new TransformerLoadException("cannot load transformer class " + ex.getMessage() + " from module " + moduleId, ex);
        }
        catch (ModuleLoadException ex) {
            throw new TransformerLoadException("cannot load module " + moduleId, ex);
        }
    }

    static Class<?> loadTransformerClass(String className, ModuleIdentifier moduleId) throws ClassNotFoundException, ModuleLoadException {
        try {
            return Module.loadClassFromCallerModuleLoader((ModuleIdentifier)moduleId, (String)className);
        }
        catch (ClassNotFoundException ex) {
            if (!TransformerFactory.isSimpleJavaIdentifier(className)) {
                throw ex;
            }
            return Module.loadClassFromCallerModuleLoader((ModuleIdentifier)moduleId, (String)TransformerFactory.qualifiedTransformerName(className));
        }
    }

    static String qualifiedTransformerName(String className) {
        String pkg = TransformerFactory.class.getPackage().getName();
        String suffix = Transformer.class.getSimpleName();
        StringBuilder sb = new StringBuilder();
        sb.append(pkg);
        sb.append('.');
        sb.append(className);
        if (!className.endsWith(suffix)) {
            sb.append(suffix);
        }
        return sb.toString();
    }

    private static ModuleIdentifier moduleId(String moduleSpec) {
        if (moduleSpec == null) {
            return Module.getCallerModule().getIdentifier();
        }
        return ModuleIdentifier.fromString((String)moduleSpec);
    }

    static boolean isSimpleJavaIdentifier(String className) {
        assert (className.length() > 0) : "className must be non-empty";
        if (!Character.isJavaIdentifierStart(className.charAt(0))) {
            return false;
        }
        int max = className.length();
        for (int i = 1; i < max; ++i) {
            if (Character.isJavaIdentifierPart(className.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

