/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.cas.transformer;

import java.util.Properties;
import javax.xml.transform.Transformer;
import org.soulwing.cas.api.AttributeTransformer;

public class ReplacePatternTransformer
extends AttributeTransformer<String, String> {
    public static final String PATTERN = "pattern";
    public static final String REPLACEMENT = "replacement";
    public static final String REPLACE_ALL = "replace-all";
    private String pattern;
    private String replacement;
    private boolean replaceAll;

    public void initialize(Properties properties) {
        super.initialize(properties);
        this.pattern = properties.getProperty(PATTERN);
        this.replacement = properties.getProperty(REPLACEMENT, "");
        this.replaceAll = Boolean.parseBoolean(properties.getProperty(REPLACE_ALL, Boolean.FALSE.toString()));
        if (this.pattern == null) {
            throw new IllegalArgumentException("pattern is required");
        }
    }

    public String transform(String value) {
        if (this.replaceAll) {
            return value.replaceAll(this.pattern, this.replacement);
        }
        return value.replaceFirst(this.pattern, this.replacement);
    }

    public String toString() {
        return String.format("%s(%s='%s', %s='%s', %s=%s)", ((Object)((Object)this)).getClass().getSimpleName().replaceFirst(Transformer.class.getSimpleName() + "$", ""), PATTERN, this.pattern, REPLACEMENT, this.replacement, REPLACE_ALL, this.replaceAll);
    }
}

