/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.cas.service;

import java.util.Map;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.soulwing.cas.api.Transformer;
import org.soulwing.cas.api.UserPrincipal;
import org.soulwing.cas.service.Authenticator;
import org.soulwing.cas.service.TransformingMap;

class JasigUserPrincipal
implements UserPrincipal {
    private static final long serialVersionUID = 1805860723380323513L;
    private final Authenticator authenticator;
    private final AttributePrincipal delegate;
    private final Map<String, Object> attributes;

    public JasigUserPrincipal(Authenticator authenticator, AttributePrincipal delegate, Map<String, Transformer<Object, Object>> transformers) {
        this.authenticator = authenticator;
        this.delegate = delegate;
        this.attributes = new TransformingMap(delegate.getAttributes(), transformers);
    }

    public String getName() {
        return this.delegate.getName();
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public String generateProxyTicket(String service) throws IllegalStateException {
        String ticket = this.delegate.getProxyTicketFor(service);
        if (ticket == null) {
            throw new IllegalStateException("proxy granting ticket unavailable");
        }
        return ticket;
    }

    public String getLogoutUrl() {
        return this.generateLogoutUrl(null);
    }

    public String generateLogoutUrl(String path) {
        return this.authenticator.logoutUrl(path);
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.getName();
    }
}

