/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.cas.service;

import org.jasig.cas.client.proxy.Cas20ProxyRetriever;
import org.jasig.cas.client.proxy.ProxyGrantingTicketStorage;
import org.jasig.cas.client.proxy.ProxyRetriever;
import org.jasig.cas.client.ssl.HttpURLConnectionFactory;
import org.jasig.cas.client.validation.AbstractUrlBasedTicketValidator;
import org.jasig.cas.client.validation.Cas10TicketValidator;
import org.jasig.cas.client.validation.Cas20ProxyTicketValidator;
import org.jasig.cas.client.validation.Cas20ServiceTicketValidator;
import org.jasig.cas.client.validation.Cas30ProxyTicketValidator;
import org.jasig.cas.client.validation.Cas30ServiceTicketValidator;
import org.jasig.cas.client.validation.ProxyList;
import org.jasig.cas.client.validation.Saml11TicketValidator;
import org.jasig.cas.client.validation.TicketValidator;
import org.soulwing.cas.service.Authenticator;
import org.soulwing.cas.service.Configuration;
import org.soulwing.cas.service.JasigAuthenticator;
import org.soulwing.cas.service.ProxyCallbackHandler;
import org.soulwing.cas.ssl.HttpsURLConnectionFactory;

public class AuthenticatorFactory {
    public static Authenticator newInstance(Configuration config, String proxyCallbackUrl, ProxyCallbackHandler proxyCallbackHandler) {
        HttpsURLConnectionFactory connectionFactory = new HttpsURLConnectionFactory(config.getSslContext(), config.getHostnameVerifier());
        TicketValidator validator = AuthenticatorFactory.createTicketValidator(config, connectionFactory);
        if (validator instanceof Cas20ServiceTicketValidator) {
            AuthenticatorFactory.configureServiceValidator(config, proxyCallbackUrl, proxyCallbackHandler, connectionFactory, (Cas20ServiceTicketValidator)validator);
        }
        if (validator instanceof Cas20ProxyTicketValidator) {
            AuthenticatorFactory.configureProxyValidator(config, (Cas20ProxyTicketValidator)validator);
        }
        if (validator instanceof Saml11TicketValidator) {
            AuthenticatorFactory.configureSamlValidator(config, (Saml11TicketValidator)validator);
        }
        return new JasigAuthenticator(config, validator);
    }

    private static TicketValidator createTicketValidator(Configuration config, HttpURLConnectionFactory connectionFactory) {
        AbstractUrlBasedTicketValidator validator = AuthenticatorFactory.newTicketValidator(config);
        validator.setEncoding(config.getEncoding());
        validator.setRenew(config.isRenew());
        validator.setURLConnectionFactory(connectionFactory);
        return validator;
    }

    private static void configureServiceValidator(Configuration config, String proxyCallbackUrl, ProxyCallbackHandler proxyCallbackHandler, HttpURLConnectionFactory connectionFactory, Cas20ServiceTicketValidator validator) {
        if (config.isProxyCallbackEnabled()) {
            validator.setProxyCallbackUrl(proxyCallbackUrl);
            validator.setProxyGrantingTicketStorage((ProxyGrantingTicketStorage)proxyCallbackHandler.getStorage());
            validator.setProxyRetriever((ProxyRetriever)new Cas20ProxyRetriever(config.getServerUrl(), config.getEncoding(), connectionFactory));
        }
    }

    private static void configureSamlValidator(Configuration config, Saml11TicketValidator validator) {
        validator.setTolerance(config.getClockSkewTolerance());
    }

    private static void configureProxyValidator(Configuration config, Cas20ProxyTicketValidator validator) {
        validator.setAcceptAnyProxy(config.isAcceptAnyProxy());
        validator.setAllowEmptyProxyChain(config.isAllowEmptyProxyChain());
        validator.setAllowedProxyChains(new ProxyList(config.getAllowedProxyChains()));
    }

    private static AbstractUrlBasedTicketValidator newTicketValidator(Configuration config) {
        switch (config.getProtocol()) {
            case CAS1_0: {
                return new Cas10TicketValidator(config.getServerUrl());
            }
            case CAS2_0: {
                if (config.isProxySupported()) {
                    return new Cas20ProxyTicketValidator(config.getServerUrl());
                }
                return new Cas20ServiceTicketValidator(config.getServerUrl());
            }
            case CAS3_0: {
                if (config.isProxySupported()) {
                    return new Cas30ProxyTicketValidator(config.getServerUrl());
                }
                return new Cas30ServiceTicketValidator(config.getServerUrl());
            }
            case SAML1_1: {
                return new Saml11TicketValidator(config.getServerUrl());
            }
        }
        throw new IllegalArgumentException("unrecognized protocol");
    }
}

