/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.cas.jaas;

import java.security.AccessController;
import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.as.core.security.RealmRole;
import org.jboss.as.core.security.RealmUser;
import org.jboss.as.core.security.SubjectUserInfo;
import org.jboss.as.domain.management.AuthMechanism;
import org.jboss.as.domain.management.AuthorizingCallbackHandler;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.soulwing.cas.jaas.IdentityAssertionLoginModule;
import org.soulwing.cas.jaas.JaasLogger;

public class DelegatingIdentityAssertionLoginModule
extends IdentityAssertionLoginModule {
    public static final String REALM = "realm";
    public static final String DEFAULT_REALM = "ApplicationRealm";
    private String realmName;
    private SecurityRealm realm;
    private AuthorizingCallbackHandler authorizingCallbackHandler;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        ServiceController controller;
        super.initialize(subject, callbackHandler, sharedState, options);
        this.realmName = (String)options.get(REALM);
        if (this.realmName == null) {
            this.realmName = DEFAULT_REALM;
        }
        if ((controller = DelegatingIdentityAssertionLoginModule.serviceContainer().getService(SecurityRealm.ServiceUtil.createServiceName((String)this.realmName))) != null) {
            this.realm = (SecurityRealm)controller.getValue();
        }
        if (this.realm == null) {
            throw new IllegalArgumentException("realm '" + this.realmName + "' not found");
        }
        Set mechs = this.realm.getSupportedAuthenticationMechanisms();
        if (mechs.isEmpty()) {
            throw new IllegalArgumentException("realm '" + this.realmName + "' does not support any authentication mechanisms");
        }
        AuthMechanism mech = AuthMechanism.PLAIN;
        if (!mechs.contains(mech)) {
            mech = (AuthMechanism)mechs.iterator().next();
        }
        this.authorizingCallbackHandler = this.realm.getAuthorizingCallbackHandler(mech);
        if (this.authorizingCallbackHandler == null) {
            throw new IllegalArgumentException("realm '" + this.realmName + "' does not provide authorization");
        }
        if (JaasLogger.LOGGER.isDebugEnabled()) {
            JaasLogger.LOGGER.debug((Object)("attached to realm '" + this.realmName + "'"));
        }
    }

    @Override
    protected Set<Principal> getRoles() throws LoginException {
        Set<Principal> roles = super.getRoles();
        try {
            RealmUser user = new RealmUser(this.assertion.getPrincipal().getName());
            SubjectUserInfo subjectUserInfo = this.authorizingCallbackHandler.createSubjectUserInfo(Collections.singleton(user));
            Set<RealmRole> realmRoles = subjectUserInfo.getSubject().getPrincipals(RealmRole.class);
            if (JaasLogger.LOGGER.isDebugEnabled()) {
                JaasLogger.LOGGER.debug((Object)("user '" + user + '@' + this.realmName + "' has roles " + realmRoles));
            }
            for (RealmRole role : realmRoles) {
                roles.add(this.createRole(role.getName()));
            }
        }
        catch (Exception ex) {
            JaasLogger.LOGGER.error((Object)("error getting realm roles: " + ex), (Throwable)ex);
            throw new LoginException("error getting realm roles: " + ex);
        }
        return roles;
    }

    private static ServiceContainer serviceContainer() {
        if (System.getSecurityManager() == null) {
            return CurrentServiceContainer.getServiceContainer();
        }
        return (ServiceContainer)AccessController.doPrivileged(CurrentServiceContainer.GET_ACTION);
    }
}

