/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.cas.extension;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.soulwing.cas.extension.AbstractResourceReaderWriter;
import org.soulwing.cas.extension.HostReaderWriter;
import org.soulwing.cas.ssl.HostnameVerifierType;

class HostnameVerifierReaderWriter
extends AbstractResourceReaderWriter {
    private static final HostReaderWriter HOST_RW = new HostReaderWriter();

    public HostnameVerifierReaderWriter() {
        super("hostname-verifier", HOST_RW);
    }

    @Override
    protected String getResourceKey() {
        return "type";
    }

    @Override
    protected void handleAttributes(XMLStreamReader reader) throws XMLStreamException {
        super.handleAttributes(reader);
        ModelNode op = this.parser.lastOperation();
        this.validateType(op);
        op.get("hosts").setEmptyList();
    }

    private void validateType(ModelNode op) throws XMLStreamException {
        PathAddress address = PathAddress.pathAddress((ModelNode)op.get("address"));
        String type = address.getLastElement().getValue();
        try {
            HostnameVerifierType.toObject(type);
        }
        catch (IllegalArgumentException ex) {
            throw new XMLStreamException("unrecognized server host verifier type '" + type + "'");
        }
    }

    @Override
    public void writeChildResources(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        ModelNode hostsNode = node.get("hosts");
        if (hostsNode.isDefined()) {
            for (ModelNode proxy : hostsNode.asList()) {
                HOST_RW.writeResource(writer, proxy);
            }
        }
    }
}

