/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.cas.extension;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.RestartParentResourceAddHandler;
import org.jboss.as.controller.RestartParentResourceRemoveHandler;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.soulwing.cas.extension.Paths;
import org.soulwing.cas.extension.ProfileDefinition;
import org.soulwing.cas.extension.ProfileService;
import org.soulwing.cas.extension.ResourceUtil;
import org.soulwing.cas.extension.TransformerDefinition;

public class AttributeTransformDefinition
extends SimpleResourceDefinition {
    public static final AttributeTransformDefinition INSTANCE = new AttributeTransformDefinition();

    public static AttributeDefinition[] attributes() {
        return new AttributeDefinition[0];
    }

    private AttributeTransformDefinition() {
        super(Paths.ATTRIBUTE_TRANSFORM, (ResourceDescriptionResolver)ResourceUtil.getResolver("cas-profile", "attribute-transform"), (OperationStepHandler)AttributeTransformAdd.INSTANCE, (OperationStepHandler)AttributeTransformRemove.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition attribute : AttributeTransformDefinition.attributes()) {
            resourceRegistration.registerReadWriteAttribute(attribute, null, (OperationStepHandler)ProfileDefinition.ProfileWriteAttributeHandler.INSTANCE);
        }
        super.registerAttributes(resourceRegistration);
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        super.registerChildren(resourceRegistration);
        resourceRegistration.registerSubModel((ResourceDefinition)TransformerDefinition.INSTANCE);
    }

    static class AttributeTransformRemove
    extends RestartParentResourceRemoveHandler {
        static final AttributeTransformRemove INSTANCE = new AttributeTransformRemove();

        private AttributeTransformRemove() {
            super("cas-profile");
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
            ProfileService.ServiceUtil.installService(context, parentModel, parentAddress);
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return ProfileService.ServiceUtil.profileServiceName(parentAddress);
        }
    }

    static class AttributeTransformAdd
    extends RestartParentResourceAddHandler {
        static final AttributeTransformAdd INSTANCE = new AttributeTransformAdd();

        private AttributeTransformAdd() {
            super("cas-profile");
        }

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition attribute : AttributeTransformDefinition.attributes()) {
                attribute.validateAndSet(operation, model);
            }
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
            ProfileService.ServiceUtil.installService(context, parentModel, parentAddress);
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return ProfileService.ServiceUtil.profileServiceName(parentAddress);
        }
    }
}

