/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.cas.extension;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.soulwing.cas.extension.ResourceParser;
import org.soulwing.cas.extension.ResourceReader;

public abstract class AbstractResourceParser
implements ResourceParser {
    private final ResourceReader delegate;
    private final Deque<List<ModelNode>> opStack = new LinkedList<List<ModelNode>>();
    private final Deque<ResourceReader> stack = new LinkedList<ResourceReader>();
    private final Map<AttachmentKey<?>, Object> attachments = new HashMap();
    private List<ModelNode> ops;

    protected AbstractResourceParser(ResourceReader delegate) {
        this.delegate = delegate;
    }

    @Override
    public void readElement(XMLStreamReader reader, List<ModelNode> ops) throws XMLStreamException {
        this.ops = ops;
        this.push(this.delegate);
        this.init();
        block5: while (reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    this.peek().startElement(reader, reader.getNamespaceURI(), reader.getLocalName());
                    continue block5;
                }
                case 2: {
                    this.peek().endElement(reader, reader.getNamespaceURI(), reader.getLocalName());
                    continue block5;
                }
                case 4: {
                    this.peek().characters(reader, reader.getText());
                    continue block5;
                }
            }
        }
    }

    protected void init() {
    }

    private ResourceReader peek() {
        if (this.stack.isEmpty()) {
            throw new RuntimeException("stack underflow");
        }
        return this.stack.peek();
    }

    @Override
    public void push(ResourceReader reader) {
        reader.init(this);
        this.stack.push(reader);
        ArrayList ops = new ArrayList();
        if (!this.opStack.isEmpty()) {
            ops.addAll(this.opStack.peek());
        }
        this.opStack.push(ops);
    }

    @Override
    public void pop() {
        this.stack.pop();
        this.opStack.pop();
    }

    @Override
    public void unexpectedElement(XMLStreamReader reader) throws XMLStreamException {
        throw new XMLStreamException("unexpected element {" + reader.getNamespaceURI() + "}" + reader.getLocalName());
    }

    @Override
    public void unexpectedEndElement(XMLStreamReader reader) throws XMLStreamException {
        throw new XMLStreamException("unexpected end element {" + reader.getNamespaceURI() + "}" + reader.getLocalName());
    }

    @Override
    public void unexpectedAttribute(XMLStreamReader reader, int index) throws XMLStreamException {
        throw new XMLStreamException("unexpected attribute {" + reader.getAttributeNamespace(index) + "}" + reader.getAttributeLocalName(index));
    }

    @Override
    public void missingAttributes(XMLStreamReader reader, Set<String> names) throws XMLStreamException {
        throw new XMLStreamException("missing attributes: " + names);
    }

    @Override
    public void duplicateAttribute(XMLStreamReader reader, String name) throws XMLStreamException {
        throw new XMLStreamException("duplicate attribute " + name);
    }

    @Override
    public void addOperation(ModelNode op, String type, String name) {
        PathAddress addr = PathAddress.pathAddress((PathElement[])new PathElement[0]);
        List<ModelNode> ops = this.opStack.peek();
        if (!ops.isEmpty()) {
            ModelNode parent = ops.get(ops.size() - 1);
            for (ModelNode node : parent.get("address").asList()) {
                Property property = node.asProperty();
                addr = addr.append(property.getName(), property.getValue().asString());
            }
        }
        addr = addr.append(type, name);
        op.get("address").set(addr.toModelNode());
        this.ops.add(op);
        this.opStack.peek().add(op);
    }

    @Override
    public ModelNode lastOperation() {
        return this.ops.get(this.ops.size() - 1);
    }

    @Override
    public <T> T getAttachment(AttachmentKey<T> key) {
        return (T)key.cast(this.attachments.get(key));
    }

    @Override
    public <T> T putAttachment(AttachmentKey<T> key, T value) {
        return (T)key.cast(this.attachments.put(key, value));
    }

    @Override
    public <T> T removeAttachment(AttachmentKey<T> key) {
        return (T)key.cast(this.attachments.remove(key));
    }
}

