/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.cas.deployment;

import java.io.InputStream;
import java.util.Deque;
import java.util.LinkedList;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.soulwing.cas.deployment.AppConfiguration;
import org.soulwing.cas.deployment.DescriptorParseException;
import org.soulwing.cas.deployment.DescriptorParser;
import org.soulwing.cas.deployment.DescriptorReader;
import org.soulwing.cas.deployment.RootReader;

class XMLStreamDescriptorParser
implements DescriptorParser {
    private static final XMLInputFactory factory = XMLInputFactory.newFactory();
    private final Deque<DescriptorReader> stack = new LinkedList<DescriptorReader>();
    private boolean stopped;

    XMLStreamDescriptorParser() {
    }

    @Override
    public AppConfiguration parse(InputStream inputStream) throws DescriptorParseException {
        try {
            return this.parse(factory.createXMLStreamReader(inputStream));
        }
        catch (XMLStreamException ex) {
            throw new DescriptorParseException(ex.getMessage(), ex);
        }
    }

    private AppConfiguration parse(XMLStreamReader reader) throws XMLStreamException {
        AppConfiguration config = new AppConfiguration();
        this.push(RootReader.INSTANCE);
        while (!this.stopped && reader.hasNext()) {
            int type = reader.next();
            switch (type) {
                case 1: {
                    this.peek().startElement(reader, reader.getNamespaceURI(), reader.getLocalName(), config);
                    break;
                }
                case 2: {
                    this.peek().endElement(reader, reader.getNamespaceURI(), reader.getLocalName(), config);
                    break;
                }
                case 4: {
                    this.peek().characters(reader, config);
                    break;
                }
            }
        }
        if (this.stopped) {
            return null;
        }
        return config;
    }

    @Override
    public void push(DescriptorReader reader) {
        reader.init(this);
        this.stack.push(reader);
    }

    @Override
    public void pop() {
        this.assertStackNotEmpty();
        this.stack.pop();
    }

    private DescriptorReader peek() {
        this.assertStackNotEmpty();
        return this.stack.peek();
    }

    private void assertStackNotEmpty() {
        if (this.stack.isEmpty()) {
            throw new RuntimeException("stack underflow");
        }
    }

    @Override
    public void stop() {
        this.stopped = true;
    }
}

