/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.cas.deployment;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.soulwing.cas.deployment.AppConfiguration;
import org.soulwing.cas.deployment.DeploymentAttachments;
import org.soulwing.cas.deployment.DeploymentAuthenticationService;
import org.soulwing.cas.deployment.DeploymentLogger;
import org.soulwing.cas.extension.Profile;
import org.soulwing.cas.extension.ProfileService;
import org.soulwing.cas.service.AuthenticationService;
import org.soulwing.cas.undertow.CasServletExtension;
import org.wildfly.extension.undertow.deployment.UndertowAttachments;

public class ServletExtensionDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final Phase PHASE = Phase.FIRST_MODULE_USE;
    private static final int PRIORITY = 32768;
    private static final ServletExtensionDeploymentProcessor INSTANCE = new ServletExtensionDeploymentProcessor();

    private ServletExtensionDeploymentProcessor() {
    }

    public static void addStepHandler(OperationContext context) {
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            public void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("cas", PHASE, 32768, (DeploymentUnitProcessor)INSTANCE);
            }
        }, OperationContext.Stage.RUNTIME);
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        AppConfiguration config = (AppConfiguration)deploymentUnit.getAttachment(DeploymentAttachments.CAS_DESCRIPTOR);
        if (config == null) {
            return;
        }
        ServiceName authServiceName = ServiceName.of((ServiceName)phaseContext.getPhaseServiceName().getParent(), (String[])new String[]{"cas", "authentication-service"});
        this.installAuthenticationService(phaseContext, config, authServiceName);
        CasServletExtension extension = new CasServletExtension();
        this.installServletExtension(phaseContext, extension, authServiceName);
        deploymentUnit.addToAttachmentList(UndertowAttachments.UNDERTOW_SERVLET_EXTENSIONS, (Object)extension);
        DeploymentLogger.LOGGER.info((Object)("attached CAS servlet extension to deployment " + deploymentUnit.getName() + "; profile=" + config.getProfileId()));
    }

    private ServiceController<?> installAuthenticationService(DeploymentPhaseContext phaseContext, AppConfiguration config, ServiceName authServiceName) throws DeploymentUnitProcessingException {
        ServiceName profileServiceName = ProfileService.ServiceUtil.profileServiceName(config.getProfileId());
        DeploymentAuthenticationService service = new DeploymentAuthenticationService();
        ServiceController controller = phaseContext.getServiceTarget().addService(authServiceName, (Service)service).addDependency(phaseContext.getPhaseServiceName()).addDependency(profileServiceName, Profile.class, service.getProfileInjector()).install();
        return controller;
    }

    private ServiceController<?> installServletExtension(DeploymentPhaseContext phaseContext, CasServletExtension extension, ServiceName authServiceName) {
        ServiceName extensionServiceName = ServiceName.of((ServiceName)phaseContext.getPhaseServiceName().getParent(), (String[])new String[]{"cas", "servlet-extension"});
        ServiceController controller = phaseContext.getServiceTarget().addService(extensionServiceName, (Service)extension).addDependency(phaseContext.getPhaseServiceName()).addDependency(authServiceName, AuthenticationService.class, extension.getAuthenticationServiceInjector()).install();
        return controller;
    }

    public void undeploy(DeploymentUnit context) {
    }
}

