/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.cas.deployment;

import java.io.IOException;
import java.io.InputStream;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.vfs.VirtualFile;
import org.soulwing.cas.deployment.AppConfiguration;
import org.soulwing.cas.deployment.DeploymentAttachments;
import org.soulwing.cas.deployment.DeploymentLogger;
import org.soulwing.cas.deployment.DescriptorParseException;
import org.soulwing.cas.deployment.InputStreamUtil;
import org.soulwing.cas.deployment.XMLStreamDescriptorParser;

public class DescriptorDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final Phase PHASE = Phase.PARSE;
    private static final int PRIORITY = 32768;
    private static final DescriptorDeploymentProcessor INSTANCE = new DescriptorDeploymentProcessor();

    private DescriptorDeploymentProcessor() {
    }

    public static void addStepHandler(OperationContext context) {
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            public void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("cas", PHASE, 32768, (DeploymentUnitProcessor)INSTANCE);
            }
        }, OperationContext.Stage.RUNTIME);
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ResourceRoot root = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        VirtualFile descriptor = root.getRoot().getChild("WEB-INF/cas.xml");
        if (!descriptor.exists()) {
            return;
        }
        AppConfiguration config = this.parseDescriptor(descriptor);
        deploymentUnit.putAttachment(DeploymentAttachments.CAS_DESCRIPTOR, (Object)config);
        DeploymentLogger.LOGGER.info((Object)("deployment unit " + deploymentUnit + " is CAS enabled"));
        DeploymentLogger.LOGGER.debug((Object)("deployment configuration " + config));
    }

    private AppConfiguration parseDescriptor(VirtualFile descriptor) throws DeploymentUnitProcessingException {
        try {
            if (this.isEmptyFile(descriptor)) {
                return new AppConfiguration();
            }
            XMLStreamDescriptorParser parser = new XMLStreamDescriptorParser();
            AppConfiguration config = parser.parse(descriptor.openStream());
            return config;
        }
        catch (IOException | DescriptorParseException ex) {
            throw new DeploymentUnitProcessingException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEmptyFile(VirtualFile descriptor) throws IOException {
        if (descriptor.getSize() == 0L) {
            return true;
        }
        InputStream inputStream = descriptor.openStream();
        try {
            boolean bl = InputStreamUtil.isEmptyStream(inputStream);
            return bl;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

