/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.cas.deployment;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.soulwing.cas.deployment.AppConfiguration;
import org.soulwing.cas.deployment.DeploymentAttachments;
import org.soulwing.cas.deployment.DeploymentLogger;

public class DependenciesDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final Phase PHASE = Phase.DEPENDENCIES;
    private static final int PRIORITY = 32768;
    private static final DependenciesDeploymentProcessor INSTANCE = new DependenciesDeploymentProcessor();

    private DependenciesDeploymentProcessor() {
    }

    public static void addStepHandler(OperationContext context) {
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            public void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("cas", PHASE, 32768, (DeploymentUnitProcessor)INSTANCE);
            }
        }, OperationContext.Stage.RUNTIME);
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        AppConfiguration config = (AppConfiguration)deploymentUnit.getAttachment(DeploymentAttachments.CAS_DESCRIPTOR);
        if (config == null || !config.isAddDependencies()) {
            return;
        }
        ModuleIdentifier moduleId = Module.getCallerModule().getIdentifier();
        ModuleLoader loader = Module.getBootModuleLoader();
        ModuleDependency dependency = new ModuleDependency(loader, moduleId, false, true, false, false);
        ModuleSpecification moduleSpec = (ModuleSpecification)phaseContext.getDeploymentUnit().getAttachment(Attachments.MODULE_SPECIFICATION);
        moduleSpec.addSystemDependency(dependency);
        DeploymentLogger.LOGGER.info((Object)("added CAS module dependency to deployment " + deploymentUnit.getName()));
    }

    public void undeploy(DeploymentUnit context) {
    }
}

