/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.xml.api;

import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.grammar.LexerlessGrammarBuilder;

public enum XmlGrammar implements GrammarRuleKey
{
    YES,
    NO,
    DOCUMENT,
    CHAR,
    S,
    NAME,
    NM_TOKEN,
    ENTITY_VALUE,
    ATT_VALUE,
    SYSTEM_LITERAL,
    PUBID_LITERAL,
    CHAR_DATA,
    COMMENT,
    PI,
    PI_TARGET,
    CD_SECT,
    CD_START,
    CDATA,
    CD_END,
    PROLOG,
    XML_DECL,
    VERSION_INFO,
    EQ,
    VERSION_NUM,
    MISC,
    DOC_TYPE_DECL,
    DECL_SEP,
    INT_SUBSET,
    MARKUP_DECL,
    EXT_SUBSET,
    EXT_SUBSET_DECL,
    SD_DECL,
    ELEMENT,
    S_TAG,
    ATTRIBUTE,
    E_TAG,
    CONTENT,
    EMPTY_ELEM_TAG,
    ELEMENT_DECL,
    CONTENT_SPEC,
    CHILDREN,
    CP,
    CHOICE,
    SEQ,
    MIXED,
    ATT_LIST_DECL,
    ATT_DEF,
    ATT_TYPE,
    STRING_TYPE,
    TOKENIZED_TYPE,
    ENUMERATED_TYPE,
    NOTATION_TYPE,
    ENUMERATION,
    DEFAULT_DECL,
    CONDITIONAL_SECT,
    INCLUDE_SECT,
    IGNORE_SECT,
    IGNORE_SECT_CONTENTS,
    IGNORE,
    CHAR_REF,
    REFERENCE,
    ENTITY_REF,
    PE_REFERENCE,
    ENTITY_DECL,
    GE_DECL,
    PE_DECL,
    ENTITY_DEF,
    PE_DEF,
    EXTERNAL_ID,
    NDATA_DECL,
    TEXT_DECL,
    ENCODING_DECL,
    ENC_NAME,
    NOTATION_DECL,
    PUBLIC_ID;

    private static final String CHAR_REGEXP = "[\u0001-\ud7ff\ue000-\ufffd]";
    private static final String S_REGEXP = "[ \t\r\n]++";
    private static final String NAME_START_CHAR_REGEXP = "[:A-Z_a-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd]";
    private static final String NAME_CHAR_REGEXP = "(?:[:A-Z_a-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd]|[-.0-9\u00b7\u0300-\u036f\u203f-\u2040])";
    private static final String NAME_REGEXP = "(?:[:A-Z_a-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd](?:[:A-Z_a-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd]|[-.0-9\u00b7\u0300-\u036f\u203f-\u2040])*+)";
    private static final String NM_TOKEN_REGEXP = "(?:(?:[:A-Z_a-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd]|[-.0-9\u00b7\u0300-\u036f\u203f-\u2040])++)";
    private static final String PUBID_CHAR_REGEXP = "[ \r\na-zA-Z0-9-'()+,./:=?;!*#@$_%]";
    private static final String COMMENT_REGEXP = "<!--(?:(?!-)[\u0001-\ud7ff\ue000-\ufffd]|-(?!-)[\u0001-\ud7ff\ue000-\ufffd])*+-->";
    private static final String CHAR_REF_REGEXP = "(?:&#(?:[0-9]++|x[0-9a-fA-F]++);)";
    private static final String ENC_NAME_REGEXP = "(?:[A-Za-z][A-Za-z0-9._-]++)";

    public static LexerlessGrammarBuilder createGrammarBuilder() {
        LexerlessGrammarBuilder b = LexerlessGrammarBuilder.create();
        b.rule((GrammarRuleKey)YES).is((Object)"yes");
        b.rule((GrammarRuleKey)NO).is((Object)"no");
        b.rule((GrammarRuleKey)DOCUMENT).is((Object)PROLOG, new Object[]{ELEMENT, b.zeroOrMore((Object)MISC)});
        b.rule((GrammarRuleKey)CHAR).is(b.regexp(CHAR_REGEXP));
        b.rule((GrammarRuleKey)S).is(b.skippedTrivia(b.regexp(S_REGEXP))).skip();
        b.rule((GrammarRuleKey)NAME).is(b.regexp(NAME_REGEXP));
        b.rule((GrammarRuleKey)NM_TOKEN).is(b.regexp(NM_TOKEN_REGEXP));
        b.rule((GrammarRuleKey)ENTITY_VALUE).is(b.firstOf(b.sequence((Object)Character.valueOf('\"'), b.zeroOrMore(b.firstOf(b.regexp("[^%&\"]++"), (Object)PE_REFERENCE, new Object[]{REFERENCE})), new Object[]{Character.valueOf('\"')}), b.sequence((Object)Character.valueOf('\''), b.zeroOrMore(b.firstOf(b.regexp("[^%&']++"), (Object)PE_REFERENCE, new Object[]{REFERENCE})), new Object[]{Character.valueOf('\'')})));
        b.rule((GrammarRuleKey)ATT_VALUE).is(b.firstOf(b.sequence((Object)Character.valueOf('\"'), b.zeroOrMore(b.firstOf(b.regexp("[^<&\"]++"), (Object)REFERENCE)), new Object[]{Character.valueOf('\"')}), b.sequence((Object)Character.valueOf('\''), b.zeroOrMore(b.firstOf(b.regexp("[^<&']++"), (Object)REFERENCE)), new Object[]{Character.valueOf('\'')})));
        b.rule((GrammarRuleKey)SYSTEM_LITERAL).is(b.firstOf(b.sequence((Object)Character.valueOf('\"'), b.regexp("[^\"]*+"), new Object[]{Character.valueOf('\"')}), b.sequence((Object)Character.valueOf('\''), b.regexp("[^']*+"), new Object[]{Character.valueOf('\'')})));
        b.rule((GrammarRuleKey)PUBID_LITERAL).is(b.firstOf(b.sequence((Object)Character.valueOf('\"'), b.regexp("[ \r\na-zA-Z0-9-'()+,./:=?;!*#@$_%]*+"), new Object[]{Character.valueOf('\"')}), b.sequence((Object)Character.valueOf('\''), b.regexp("(?:(?!')[ \r\na-zA-Z0-9-'()+,./:=?;!*#@$_%])*+"), new Object[]{Character.valueOf('\'')})));
        b.rule((GrammarRuleKey)CHAR_DATA).is(b.regexp("[^<&]*+"));
        b.rule((GrammarRuleKey)COMMENT).is(b.commentTrivia(b.regexp(COMMENT_REGEXP))).skip();
        b.rule((GrammarRuleKey)PI).is((Object)"<?", new Object[]{PI_TARGET, b.optional((Object)S, new Object[]{b.regexp("((?!\\?>)[\u0001-\ud7ff\ue000-\ufffd])++")}), "?>"});
        b.rule((GrammarRuleKey)PI_TARGET).is(b.nextNot(b.firstOf((Object)Character.valueOf('x'), (Object)Character.valueOf('X')), new Object[]{b.firstOf((Object)Character.valueOf('m'), (Object)Character.valueOf('M')), b.firstOf((Object)Character.valueOf('l'), (Object)Character.valueOf('L'))}), new Object[]{NAME});
        b.rule((GrammarRuleKey)CD_SECT).is((Object)CD_START, new Object[]{CDATA, CD_END});
        b.rule((GrammarRuleKey)CD_START).is((Object)"<![CDATA[");
        b.rule((GrammarRuleKey)CDATA).is(b.regexp("(?:(?!]]>)[\u0001-\ud7ff\ue000-\ufffd])*+"));
        b.rule((GrammarRuleKey)CD_END).is((Object)"]]>");
        b.rule((GrammarRuleKey)PROLOG).is(b.optional((Object)XML_DECL), new Object[]{b.zeroOrMore((Object)MISC), b.optional((Object)DOC_TYPE_DECL, new Object[]{b.zeroOrMore((Object)MISC)})});
        b.rule((GrammarRuleKey)XML_DECL).is((Object)"<?xml", new Object[]{VERSION_INFO, b.optional((Object)ENCODING_DECL), b.optional((Object)SD_DECL), b.optional((Object)S), "?>"});
        b.rule((GrammarRuleKey)VERSION_INFO).is((Object)S, new Object[]{"version", EQ, b.firstOf(b.sequence((Object)Character.valueOf('\"'), (Object)VERSION_NUM, new Object[]{Character.valueOf('\"')}), b.sequence((Object)Character.valueOf('\''), (Object)VERSION_NUM, new Object[]{Character.valueOf('\'')}))});
        b.rule((GrammarRuleKey)EQ).is(b.optional((Object)S), new Object[]{Character.valueOf('='), b.optional((Object)S)});
        b.rule((GrammarRuleKey)VERSION_NUM).is((Object)"1.", new Object[]{b.regexp("[0-9]++")});
        b.rule((GrammarRuleKey)MISC).is(b.firstOf((Object)S, (Object)COMMENT, new Object[]{PI}));
        b.rule((GrammarRuleKey)DOC_TYPE_DECL).is((Object)"<!DOCTYPE", new Object[]{S, NAME, b.optional((Object)S, new Object[]{EXTERNAL_ID}), b.optional((Object)S), b.optional((Object)Character.valueOf('['), new Object[]{INT_SUBSET, Character.valueOf(']'), b.optional((Object)S)}), Character.valueOf('>')});
        b.rule((GrammarRuleKey)DECL_SEP).is(b.firstOf((Object)S, (Object)PE_REFERENCE));
        b.rule((GrammarRuleKey)INT_SUBSET).is(b.zeroOrMore(b.firstOf((Object)MARKUP_DECL, (Object)DECL_SEP)));
        b.rule((GrammarRuleKey)MARKUP_DECL).is(b.firstOf((Object)ELEMENT_DECL, (Object)ATT_LIST_DECL, new Object[]{ENTITY_DECL, NOTATION_DECL, PI, COMMENT}));
        b.rule((GrammarRuleKey)EXT_SUBSET).is(b.optional((Object)TEXT_DECL), new Object[]{EXT_SUBSET_DECL});
        b.rule((GrammarRuleKey)EXT_SUBSET_DECL).is(b.zeroOrMore(b.firstOf((Object)MARKUP_DECL, (Object)CONDITIONAL_SECT, new Object[]{DECL_SEP})));
        b.rule((GrammarRuleKey)SD_DECL).is((Object)S, new Object[]{"standalone", EQ, b.firstOf(b.sequence((Object)Character.valueOf('\"'), b.firstOf((Object)YES, (Object)NO), new Object[]{Character.valueOf('\"')}), b.sequence((Object)Character.valueOf('\''), b.firstOf((Object)YES, (Object)NO), new Object[]{Character.valueOf('\'')}))});
        b.rule((GrammarRuleKey)ELEMENT).is(b.firstOf((Object)EMPTY_ELEM_TAG, b.sequence((Object)S_TAG, (Object)CONTENT, new Object[]{E_TAG})));
        b.rule((GrammarRuleKey)S_TAG).is((Object)Character.valueOf('<'), new Object[]{NAME, b.zeroOrMore((Object)S, new Object[]{ATTRIBUTE}), b.optional((Object)S), Character.valueOf('>')});
        b.rule((GrammarRuleKey)ATTRIBUTE).is((Object)NAME, new Object[]{EQ, ATT_VALUE});
        b.rule((GrammarRuleKey)E_TAG).is((Object)"</", new Object[]{NAME, b.optional((Object)S), Character.valueOf('>')});
        b.rule((GrammarRuleKey)CONTENT).is(b.optional((Object)CHAR_DATA), new Object[]{b.zeroOrMore(b.firstOf((Object)ELEMENT, (Object)REFERENCE, new Object[]{CD_SECT, PI, COMMENT}), new Object[]{b.optional((Object)CHAR_DATA)})});
        b.rule((GrammarRuleKey)EMPTY_ELEM_TAG).is((Object)Character.valueOf('<'), new Object[]{NAME, b.zeroOrMore((Object)S, new Object[]{ATTRIBUTE}), b.optional((Object)S), "/>"});
        b.rule((GrammarRuleKey)ELEMENT_DECL).is((Object)"<!ELEMENT", new Object[]{S, NAME, S, CONTENT_SPEC, b.optional((Object)S), Character.valueOf('>')});
        b.rule((GrammarRuleKey)CONTENT_SPEC).is(b.firstOf((Object)"EMPTY", (Object)"ANY", new Object[]{MIXED, CHILDREN}));
        b.rule((GrammarRuleKey)CHILDREN).is(b.firstOf((Object)CHOICE, (Object)SEQ), new Object[]{b.optional(b.firstOf((Object)Character.valueOf('?'), (Object)Character.valueOf('*'), new Object[]{Character.valueOf('+')}))});
        b.rule((GrammarRuleKey)CP).is(b.firstOf((Object)NAME, (Object)CHOICE, new Object[]{SEQ}), new Object[]{b.optional(b.firstOf((Object)Character.valueOf('?'), (Object)Character.valueOf('*'), new Object[]{Character.valueOf('+')}))});
        b.rule((GrammarRuleKey)CHOICE).is((Object)Character.valueOf('('), new Object[]{b.optional((Object)S), CP, b.oneOrMore(b.optional((Object)S), new Object[]{Character.valueOf('|'), b.optional((Object)S), CP}), b.optional((Object)S), Character.valueOf(')')});
        b.rule((GrammarRuleKey)SEQ).is((Object)Character.valueOf('('), new Object[]{b.optional((Object)S), CP, b.zeroOrMore(b.optional((Object)S), new Object[]{Character.valueOf(','), b.optional((Object)S), CP}), b.optional((Object)S), Character.valueOf(')')});
        b.rule((GrammarRuleKey)MIXED).is(b.firstOf(b.sequence((Object)Character.valueOf('('), b.optional((Object)S), new Object[]{"#PCDATA", b.zeroOrMore(b.optional((Object)S), new Object[]{Character.valueOf('|'), b.optional((Object)S), NAME}), b.optional((Object)S), ")*"}), b.sequence((Object)Character.valueOf('('), b.optional((Object)S), new Object[]{"#PCDATA", b.optional((Object)S), Character.valueOf(')')})));
        b.rule((GrammarRuleKey)ATT_LIST_DECL).is((Object)"<!ATTLIST", new Object[]{S, NAME, b.zeroOrMore((Object)ATT_DEF), b.optional((Object)S), Character.valueOf('>')});
        b.rule((GrammarRuleKey)ATT_DEF).is((Object)S, new Object[]{NAME, S, ATT_TYPE, S, DEFAULT_DECL});
        b.rule((GrammarRuleKey)ATT_TYPE).is(b.firstOf((Object)STRING_TYPE, (Object)TOKENIZED_TYPE, new Object[]{ENUMERATED_TYPE}));
        b.rule((GrammarRuleKey)STRING_TYPE).is((Object)"CDATA");
        b.rule((GrammarRuleKey)TOKENIZED_TYPE).is(b.firstOf((Object)"IDREFS", (Object)"IDREF", new Object[]{"ID", "ENTITIES", "ENTITY", "NMTOKENS", "NMTOKEN"}));
        b.rule((GrammarRuleKey)ENUMERATED_TYPE).is(b.firstOf((Object)NOTATION_TYPE, (Object)ENUMERATION));
        b.rule((GrammarRuleKey)NOTATION_TYPE).is((Object)"NOTATION", new Object[]{S, Character.valueOf('('), b.optional((Object)S), NAME, b.zeroOrMore(b.optional((Object)S), new Object[]{Character.valueOf('|'), b.optional((Object)S), NAME}), b.optional((Object)S), Character.valueOf(')')});
        b.rule((GrammarRuleKey)ENUMERATION).is((Object)Character.valueOf('('), new Object[]{b.optional((Object)S), NM_TOKEN, b.zeroOrMore(b.optional((Object)S), new Object[]{Character.valueOf('|'), b.optional((Object)S), NM_TOKEN}), b.optional((Object)S), Character.valueOf(')')});
        b.rule((GrammarRuleKey)DEFAULT_DECL).is(b.firstOf((Object)"#REQUIRED", (Object)"#IMPLIED", new Object[]{b.sequence(b.optional((Object)"#FIXED", new Object[]{S}), (Object)ATT_VALUE)}));
        b.rule((GrammarRuleKey)CONDITIONAL_SECT).is(b.firstOf((Object)INCLUDE_SECT, (Object)IGNORE_SECT));
        b.rule((GrammarRuleKey)INCLUDE_SECT).is((Object)"<![", new Object[]{b.optional((Object)S), "INCLUDE", b.optional((Object)S), Character.valueOf('['), EXT_SUBSET_DECL, "]]>"});
        b.rule((GrammarRuleKey)IGNORE_SECT).is((Object)"<![", new Object[]{b.optional((Object)S), "IGNORE", b.optional((Object)S), Character.valueOf('['), b.optional((Object)IGNORE_SECT_CONTENTS), "]]>"});
        b.rule((GrammarRuleKey)IGNORE_SECT_CONTENTS).is(b.firstOf(b.sequence((Object)IGNORE, b.zeroOrMore((Object)"<![", new Object[]{b.optional((Object)IGNORE_SECT_CONTENTS), "]]>", b.optional((Object)IGNORE)})), b.oneOrMore((Object)"<![", new Object[]{b.optional((Object)IGNORE_SECT_CONTENTS), "]]>", b.optional((Object)IGNORE)})));
        b.rule((GrammarRuleKey)IGNORE).is(b.regexp("((?!<!\\[|]]>)[\u0001-\ud7ff\ue000-\ufffd])++"));
        b.rule((GrammarRuleKey)CHAR_REF).is(b.regexp(CHAR_REF_REGEXP));
        b.rule((GrammarRuleKey)REFERENCE).is(b.firstOf((Object)ENTITY_REF, (Object)CHAR_REF));
        b.rule((GrammarRuleKey)ENTITY_REF).is((Object)Character.valueOf('&'), new Object[]{NAME, Character.valueOf(';')});
        b.rule((GrammarRuleKey)PE_REFERENCE).is((Object)Character.valueOf('%'), new Object[]{NAME, Character.valueOf(';')});
        b.rule((GrammarRuleKey)ENTITY_DECL).is(b.firstOf((Object)GE_DECL, (Object)PE_DECL));
        b.rule((GrammarRuleKey)GE_DECL).is((Object)"<!ENTITY", new Object[]{S, NAME, S, ENTITY_DEF, b.optional((Object)S), Character.valueOf('>')});
        b.rule((GrammarRuleKey)PE_DECL).is((Object)"<!ENTITY", new Object[]{S, Character.valueOf('%'), S, NAME, S, PE_DEF, b.optional((Object)S), Character.valueOf('>')});
        b.rule((GrammarRuleKey)ENTITY_DEF).is(b.firstOf((Object)ENTITY_VALUE, b.sequence((Object)EXTERNAL_ID, b.optional((Object)NDATA_DECL))));
        b.rule((GrammarRuleKey)PE_DEF).is(b.firstOf((Object)ENTITY_VALUE, (Object)EXTERNAL_ID));
        b.rule((GrammarRuleKey)EXTERNAL_ID).is(b.firstOf(b.sequence((Object)"SYSTEM", (Object)S, new Object[]{SYSTEM_LITERAL}), b.sequence((Object)"PUBLIC", (Object)S, new Object[]{PUBID_LITERAL, S, SYSTEM_LITERAL})));
        b.rule((GrammarRuleKey)NDATA_DECL).is((Object)S, new Object[]{"NDATA", S, NAME});
        b.rule((GrammarRuleKey)TEXT_DECL).is((Object)"<?xml", new Object[]{b.optional((Object)VERSION_INFO), ENCODING_DECL, b.optional((Object)S), "?>"});
        b.rule((GrammarRuleKey)ENCODING_DECL).is((Object)S, new Object[]{"encoding", EQ, b.firstOf(b.sequence((Object)Character.valueOf('\"'), (Object)ENC_NAME, new Object[]{Character.valueOf('\"')}), b.sequence((Object)Character.valueOf('\''), (Object)ENC_NAME, new Object[]{Character.valueOf('\'')}))});
        b.rule((GrammarRuleKey)ENC_NAME).is(b.regexp(ENC_NAME_REGEXP));
        b.rule((GrammarRuleKey)NOTATION_DECL).is((Object)"<!NOTATION", new Object[]{S, NAME, S, b.firstOf((Object)EXTERNAL_ID, (Object)PUBLIC_ID), b.optional((Object)S), Character.valueOf('>')});
        b.rule((GrammarRuleKey)PUBLIC_ID).is((Object)"PUBLIC", new Object[]{S, PUBID_LITERAL});
        b.setRootRule((GrammarRuleKey)DOCUMENT);
        return b;
    }
}

