/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.parsers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import org.apache.commons.lang.StringUtils;
import org.sonar.plugins.xml.LineCountData;
import org.sonar.plugins.xml.parsers.AbstractParser;
import org.sonar.plugins.xml.parsers.UnrecoverableParseError;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public final class LineCountParser
extends AbstractParser {
    private CommentHandler commentHandler;
    private int linesNumber;
    private Set<Integer> linesOfCodeLines;
    private LineCountData data;

    public LineCountParser(String contents, Charset charset) throws IOException, SAXException {
        this.processCommentLines(contents, charset);
        this.processBlankLines(contents);
        this.data = new LineCountData(this.linesNumber, this.linesOfCodeLines, new HashSet<Integer>(this.commentHandler.effectiveCommentLines));
    }

    private void processCommentLines(String contents, Charset charset) throws SAXException, IOException {
        SAXParser parser = this.newSaxParser(false);
        XMLReader xmlReader = parser.getXMLReader();
        this.commentHandler = new CommentHandler();
        xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", this.commentHandler);
        parser.parse((InputStream)new ByteArrayInputStream(contents.getBytes(charset)), (DefaultHandler)this.commentHandler);
    }

    private void processBlankLines(String contents) {
        HashSet<Integer> blankLines = new HashSet<Integer>();
        String lineSeparatorRegexp = "(?:\r)?\n|\r";
        int currentLine = 0;
        for (String line : contents.split(lineSeparatorRegexp, -1)) {
            ++currentLine;
            if (!StringUtils.isBlank((String)line)) continue;
            blankLines.add(currentLine);
        }
        this.linesNumber = currentLine;
        this.linesOfCodeLines = new HashSet<Integer>();
        for (int line = 1; line <= this.linesNumber; ++line) {
            if (blankLines.contains(line) || this.commentHandler.commentLines.contains(line)) continue;
            this.linesOfCodeLines.add(line);
        }
    }

    public LineCountData getLineCountData() {
        return this.data;
    }

    private static class CommentHandler
    extends DefaultHandler
    implements LexicalHandler {
        private Deque<Integer> commentLines = new ArrayDeque<Integer>();
        private Deque<Integer> effectiveCommentLines = new ArrayDeque<Integer>();
        private int lastCodeLine = 0;
        private Locator locator;

        private CommentHandler() {
        }

        private void registerLineOfCode() {
            this.lastCodeLine = this.locator.getLineNumber();
            if (this.lastEffectiveCommentLine() == this.lastCodeLine) {
                this.effectiveCommentLines.pop();
            }
            if (this.lastCommentLine() == this.lastCodeLine) {
                this.commentLines.pop();
            }
        }

        private int lastEffectiveCommentLine() {
            return this.effectiveCommentLines.isEmpty() ? 0 : this.effectiveCommentLines.peek();
        }

        private int lastCommentLine() {
            return this.commentLines.isEmpty() ? 0 : this.commentLines.peek();
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
            String comment = new String(ch).substring(start, start + length);
            String[] lines = comment.split("\\n", -1);
            int currentLine = this.locator.getLineNumber() - lines.length + 1;
            for (String line : lines) {
                String commentLine;
                if (this.lastCommentLine() < currentLine && this.lastCodeLine < currentLine) {
                    this.commentLines.push(currentLine);
                }
                if (!(commentLine = line.trim()).isEmpty() && this.lastEffectiveCommentLine() < currentLine && this.lastCodeLine < currentLine) {
                    this.effectiveCommentLines.push(currentLine);
                }
                ++currentLine;
            }
        }

        @Override
        public void endCDATA() throws SAXException {
            this.registerLineOfCode();
        }

        @Override
        public void endDTD() throws SAXException {
            this.registerLineOfCode();
        }

        @Override
        public void endEntity(String name) throws SAXException {
            this.registerLineOfCode();
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            if (e.getLocalizedMessage().contains("The reference to entity \"null\"")) {
                throw new UnrecoverableParseError(e);
            }
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        @Override
        public void startCDATA() throws SAXException {
            this.registerLineOfCode();
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            this.registerLineOfCode();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.registerLineOfCode();
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.registerLineOfCode();
        }

        @Override
        public void startEntity(String name) throws SAXException {
            this.registerLineOfCode();
        }
    }
}

