/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.language;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.config.Settings;
import org.sonar.api.resources.AbstractLanguage;

public class Xml
extends AbstractLanguage {
    private static final String[] DEFAULT_SUFFIXES = new String[]{".xml"};
    public static final String KEY = "xml";
    private static final String XML_LANGUAGE_NAME = "XML";
    private Settings settings;

    public Xml(Settings settings) {
        super(KEY, XML_LANGUAGE_NAME);
        this.settings = settings;
    }

    public String[] getFileSuffixes() {
        String[] suffixes = Xml.filterEmptyStrings(this.settings.getStringArray("sonar.xml.file.suffixes"));
        if (suffixes.length == 0) {
            suffixes = DEFAULT_SUFFIXES;
        }
        return suffixes;
    }

    private static String[] filterEmptyStrings(String[] stringArray) {
        ArrayList nonEmptyStrings = Lists.newArrayList();
        for (String string : stringArray) {
            if (!StringUtils.isNotBlank((String)string.trim())) continue;
            nonEmptyStrings.add(string.trim());
        }
        return nonEmptyStrings.toArray(new String[nonEmptyStrings.size()]);
    }
}

