/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.sonar.plugins.xml.checks.XmlFile;
import org.sonar.plugins.xml.checks.XmlIssue;
import org.sonar.plugins.xml.compat.CompatibleInputFile;
import org.sonar.plugins.xml.parsers.SaxParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XmlSourceCode {
    private final List<XmlIssue> xmlIssues = new ArrayList<XmlIssue>();
    private XmlFile xmlFile;
    private Document documentNamespaceAware = null;
    private Document documentNamespaceUnaware = null;

    public XmlSourceCode(XmlFile xmlFile) {
        this.xmlFile = xmlFile;
    }

    public void addViolation(XmlIssue xmlIssue) {
        this.xmlIssues.add(xmlIssue);
    }

    InputStream createInputStream() {
        try {
            return this.xmlFile.getInputStream();
        }
        catch (IOException e) {
            throw new IllegalStateException(this.xmlFile.getAbsolutePath(), e);
        }
    }

    protected Document getDocument(boolean namespaceAware) {
        return namespaceAware ? this.documentNamespaceAware : this.documentNamespaceUnaware;
    }

    public boolean parseSource() {
        this.documentNamespaceUnaware = this.parseFile(false);
        if (this.documentNamespaceUnaware != null) {
            this.documentNamespaceAware = this.parseFile(true);
        }
        return this.documentNamespaceUnaware != null || this.documentNamespaceAware != null;
    }

    private Document parseFile(boolean namespaceAware) {
        return new SaxParser().parseDocument(this.createInputStream(), namespaceAware);
    }

    public CompatibleInputFile getInputFile() {
        return this.xmlFile.getInputFile();
    }

    public String getLogicalPath() {
        return this.xmlFile.getInputFile().absolutePath();
    }

    public List<XmlIssue> getXmlIssues() {
        return this.xmlIssues;
    }

    public int getLineForNode(Node node) {
        return SaxParser.getLineNumber(node) + this.xmlFile.getLineDelta();
    }

    public int getXMLPrologLine() {
        return this.xmlFile.getPrologLine();
    }

    public boolean isPrologFirstInSource() {
        return this.xmlFile.hasCharsBeforeProlog();
    }

    public String toString() {
        return this.xmlFile.getInputFile().absolutePath();
    }
}

