/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks;

import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.xml.checks.AbstractXmlCheck;
import org.sonar.plugins.xml.checks.XmlSourceCode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Rule(key="IndentCheck")
public class IndentCheck
extends AbstractXmlCheck {
    private static final String MESSAGE = "Make this line start at column %s.";
    @RuleProperty(key="indentSize", description="Number of white-spaces of an indent. If this property is not set, we just check that the code is indented.", defaultValue="2", type="INTEGER")
    private int indentSize = 2;
    @RuleProperty(key="tabSize", description="Equivalent number of spaces of a tabulation", defaultValue="2", type="INTEGER")
    private int tabSize = 2;

    private int collectIndent(Node node) {
        int indent = 0;
        for (Node sibling = node.getPreviousSibling(); sibling != null; sibling = sibling.getPreviousSibling()) {
            short nodeType = sibling.getNodeType();
            if (nodeType == 8 || nodeType == 1) {
                return indent;
            }
            if (nodeType != 3) continue;
            String text = sibling.getTextContent();
            if (!StringUtils.isWhitespace((String)text)) {
                return indent;
            }
            block6: for (int i = text.length() - 1; i >= 0; --i) {
                char c = text.charAt(i);
                switch (c) {
                    case '\n': {
                        return indent;
                    }
                    case '\t': {
                        indent += this.tabSize;
                        continue block6;
                    }
                    case ' ': {
                        ++indent;
                        continue block6;
                    }
                }
            }
        }
        return indent;
    }

    private static int getDepth(Node node) {
        int depth = 0;
        Node parent = node.getParentNode();
        while (parent.getParentNode() != null) {
            ++depth;
            parent = parent.getParentNode();
        }
        return depth;
    }

    @Override
    public void validate(XmlSourceCode xmlSourceCode) {
        this.setWebSourceCode(xmlSourceCode);
        Document document = this.getWebSourceCode().getDocument(false);
        if (document.getDocumentElement() != null) {
            this.validateIndent(document.getDocumentElement());
        }
    }

    private boolean validateIndent(Node node) {
        int indent;
        int depth = IndentCheck.getDepth(node);
        int expectedIndent = depth * this.indentSize;
        if (expectedIndent != (indent = this.collectIndent(node))) {
            this.createViolation(this.getWebSourceCode().getLineForNode(node), String.format(MESSAGE, expectedIndent + 1));
            return true;
        }
        boolean issueOnLine = false;
        block4: for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getNodeType()) {
                case 1: {
                    if (issueOnLine) continue block4;
                    issueOnLine = this.validateIndent(child);
                    continue block4;
                }
                case 3: {
                    if (!child.getTextContent().contains("\n")) continue block4;
                    issueOnLine = false;
                    continue block4;
                }
            }
        }
        return false;
    }
}

