/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.plugins.xml.checks.AbstractXmlCheck;
import org.sonar.plugins.xml.checks.CharBeforePrologCheck;
import org.sonar.plugins.xml.checks.IllegalTabCheck;
import org.sonar.plugins.xml.checks.IndentCheck;
import org.sonar.plugins.xml.checks.NewlineCheck;
import org.sonar.plugins.xml.checks.ParsingErrorCheck;
import org.sonar.plugins.xml.checks.XPathCheck;
import org.sonar.plugins.xml.checks.XmlSchemaCheck;

public class CheckRepository {
    public static final String REPOSITORY_KEY = "xml";
    public static final String REPOSITORY_NAME = "SonarAnalyzer";
    public static final String SONAR_WAY_PROFILE_NAME = "Sonar way";

    private CheckRepository() {
    }

    public static List<AbstractXmlCheck> getChecks() {
        return Arrays.asList(new IllegalTabCheck(), new IndentCheck(), new NewlineCheck(), new XmlSchemaCheck(), new CharBeforePrologCheck(), new ParsingErrorCheck(), new XPathCheck());
    }

    public static List<Class> getCheckClasses() {
        return CheckRepository.getChecks().stream().map(Object::getClass).collect(Collectors.toList());
    }
}

