/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.Version;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.xml.LineCounter;
import org.sonar.plugins.xml.checks.AbstractXmlCheck;
import org.sonar.plugins.xml.checks.CheckRepository;
import org.sonar.plugins.xml.checks.ParsingErrorCheck;
import org.sonar.plugins.xml.checks.XmlFile;
import org.sonar.plugins.xml.checks.XmlIssue;
import org.sonar.plugins.xml.checks.XmlSourceCode;
import org.sonar.plugins.xml.compat.CompatibilityHelper;
import org.sonar.plugins.xml.compat.CompatibleInputFile;
import org.sonar.plugins.xml.highlighting.HighlightingData;
import org.sonar.plugins.xml.highlighting.XMLHighlighting;
import org.sonar.plugins.xml.parsers.ParseException;
import org.sonar.squidbridge.api.AnalysisException;

public class XmlSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(XmlSensor.class);
    private static final Version V6_0 = Version.create((int)6, (int)0);
    private final Checks<Object> checks;
    private final FileSystem fileSystem;
    private final FilePredicate mainFilesPredicate;
    private final FileLinesContextFactory fileLinesContextFactory;

    public XmlSensor(FileSystem fileSystem, CheckFactory checkFactory, FileLinesContextFactory fileLinesContextFactory) {
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.checks = checkFactory.create("xml").addAnnotatedChecks(CheckRepository.getCheckClasses());
        this.fileSystem = fileSystem;
        this.mainFilesPredicate = fileSystem.predicates().and(fileSystem.predicates().hasType(InputFile.Type.MAIN), fileSystem.predicates().hasLanguage("xml"));
    }

    public void analyse(SensorContext sensorContext) {
        this.execute(sensorContext);
    }

    private void computeLinesMeasures(SensorContext context, XmlFile xmlFile) {
        LineCounter.analyse(context, this.fileLinesContextFactory, xmlFile);
    }

    private void runChecks(SensorContext context, XmlFile xmlFile) {
        XmlSourceCode sourceCode = new XmlSourceCode(xmlFile);
        if (sourceCode.parseSource()) {
            for (Object check : this.checks.all()) {
                ((AbstractXmlCheck)check).setRuleKey(this.checks.ruleKey(check));
                ((AbstractXmlCheck)check).validate(sourceCode);
            }
            this.saveIssue(context, sourceCode);
            try {
                XmlSensor.saveSyntaxHighlighting(context, new XMLHighlighting(xmlFile).getHighlightingData(), xmlFile.getInputFile().wrapped());
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not analyze file " + xmlFile.getAbsolutePath(), e);
            }
        }
    }

    private static void saveSyntaxHighlighting(SensorContext context, List<HighlightingData> highlightingDataList, InputFile inputFile) {
        NewHighlighting highlighting = context.newHighlighting().onFile(inputFile);
        for (HighlightingData highlightingData : highlightingDataList) {
            highlighting.highlight(highlightingData.startOffset().intValue(), highlightingData.endOffset().intValue(), highlightingData.highlightCode());
        }
        highlighting.save();
    }

    @VisibleForTesting
    protected void saveIssue(SensorContext context, XmlSourceCode sourceCode) {
        for (XmlIssue xmlIssue : sourceCode.getXmlIssues()) {
            NewIssue newIssue = context.newIssue().forRule(xmlIssue.getRuleKey());
            NewIssueLocation location = newIssue.newLocation().on((InputComponent)sourceCode.getInputFile().wrapped()).message(xmlIssue.getMessage());
            if (xmlIssue.getLine() != null) {
                location.at(sourceCode.getInputFile().selectLine(xmlIssue.getLine()));
            }
            newIssue.at(location).save();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("xml").name("XML Sensor");
    }

    public void execute(SensorContext context) {
        Optional<RuleKey> parsingErrorKey = this.getParsingErrorKey();
        for (CompatibleInputFile inputFile : CompatibilityHelper.wrap(this.fileSystem.inputFiles(this.mainFilesPredicate), context)) {
            XmlFile xmlFile = new XmlFile(inputFile, this.fileSystem);
            try {
                this.computeLinesMeasures(context, xmlFile);
                this.runChecks(context, xmlFile);
            }
            catch (ParseException e) {
                XmlSensor.processParseException(e, context, inputFile, parsingErrorKey);
            }
            catch (RuntimeException e) {
                XmlSensor.processException(e, context, inputFile);
            }
        }
    }

    private Optional<RuleKey> getParsingErrorKey() {
        for (Object obj : this.checks.all()) {
            AbstractXmlCheck check = (AbstractXmlCheck)obj;
            if (!(check instanceof ParsingErrorCheck)) continue;
            return Optional.of(this.checks.ruleKey((Object)check));
        }
        return Optional.empty();
    }

    private static void processParseException(ParseException e, SensorContext context, CompatibleInputFile inputFile, Optional<RuleKey> parsingErrorKey) {
        XmlSensor.reportAnalysisError(e, context, inputFile);
        LOG.warn("Unable to parse file {}", (Object)inputFile.absolutePath());
        LOG.warn("Cause: {}", (Object)e.getMessage());
        if (parsingErrorKey.isPresent()) {
            NewIssue newIssue = context.newIssue();
            NewIssueLocation primaryLocation = newIssue.newLocation().message("Parse error: " + e.getMessage()).on((InputComponent)inputFile.wrapped());
            newIssue.forRule(parsingErrorKey.get()).at(primaryLocation).save();
        }
    }

    private static void processException(RuntimeException e, SensorContext context, CompatibleInputFile inputFile) {
        XmlSensor.reportAnalysisError(e, context, inputFile);
        throw new AnalysisException("Unable to analyse file " + inputFile.absolutePath(), (Throwable)e);
    }

    private static void reportAnalysisError(RuntimeException e, SensorContext context, CompatibleInputFile inputFile) {
        if (context.getSonarQubeVersion().isGreaterThanOrEqual(V6_0)) {
            context.newAnalysisError().onFile(inputFile.wrapped()).message(e.getMessage()).save();
        }
    }
}

