/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml;

import java.util.HashSet;
import java.util.Set;

public class LineCountData {
    private Integer linesNumber;
    private Set<Integer> linesOfCodeLines;
    private Set<Integer> effectiveCommentLine;

    public LineCountData(Integer linesNumber, Set<Integer> linesOfCodeLines, Set<Integer> effectiveCommentLine) {
        this.linesNumber = linesNumber;
        this.linesOfCodeLines = linesOfCodeLines;
        this.effectiveCommentLine = effectiveCommentLine;
    }

    public Integer linesNumber() {
        return this.linesNumber;
    }

    public Set<Integer> linesOfCodeLines() {
        return this.linesOfCodeLines;
    }

    public Set<Integer> effectiveCommentLines() {
        return this.effectiveCommentLine;
    }

    public void updateAccordingTo(int lineDelta) {
        if (lineDelta > 0) {
            HashSet<Integer> updatedLinesOfCodeLines = new HashSet<Integer>();
            HashSet<Integer> updatedEffectiveCommentLines = new HashSet<Integer>();
            for (int i = 0; i <= this.linesNumber; ++i) {
                if (this.linesOfCodeLines.contains(i)) {
                    updatedLinesOfCodeLines.add(i + lineDelta);
                }
                if (!this.effectiveCommentLine.contains(i)) continue;
                updatedEffectiveCommentLines.add(i + lineDelta);
            }
            LineCountData lineCountData = this;
            lineCountData.linesNumber = lineCountData.linesNumber + lineDelta;
            this.linesOfCodeLines = updatedLinesOfCodeLines;
            this.effectiveCommentLine = updatedEffectiveCommentLines;
        }
    }
}

