/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client.serverid;

import com.google.common.base.Preconditions;
import javax.annotation.concurrent.Immutable;

@Immutable
public class GenerateRequest {
    private final String organization;
    private final String ip;

    private GenerateRequest(Builder builder) {
        this.organization = builder.organization;
        this.ip = builder.ip;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getIp() {
        return this.ip;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String organization;
        private String ip;

        private Builder() {
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setIp(String ip) {
            this.ip = ip;
            return this;
        }

        public GenerateRequest build() {
            Preconditions.checkArgument((this.organization != null && !this.organization.isEmpty() ? 1 : 0) != 0, (Object)"Organization must not be null or empty");
            Preconditions.checkArgument((this.ip != null && !this.ip.isEmpty() ? 1 : 0) != 0, (Object)"IP must not be null or empty");
            return new GenerateRequest(this);
        }
    }
}

