/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client.qualityprofile;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class CreateRequest {
    private final String name;
    private final String language;
    private final String organizationKey;

    private CreateRequest(Builder builder) {
        this.name = builder.name;
        this.language = builder.language;
        this.organizationKey = builder.organizationKey;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getName() {
        return this.name;
    }

    public String getOrganizationKey() {
        return this.organizationKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String language;
        private String name;
        private String organizationKey;

        private Builder() {
        }

        public Builder setLanguage(@Nullable String language) {
            this.language = language;
            return this;
        }

        public Builder setName(@Nullable String profileName) {
            this.name = profileName;
            return this;
        }

        public Builder setOrganizationKey(@Nullable String organizationKey) {
            this.organizationKey = organizationKey;
            return this;
        }

        public CreateRequest build() {
            Preconditions.checkArgument((this.language != null && !this.language.isEmpty() ? 1 : 0) != 0, (Object)"Language is mandatory and must not be empty.");
            Preconditions.checkArgument((this.name != null && !this.name.isEmpty() ? 1 : 0) != 0, (Object)"Profile name is mandatory and must not be empty.");
            Preconditions.checkArgument((this.organizationKey == null || !this.organizationKey.isEmpty() ? 1 : 0) != 0, (Object)"Organization key may be either null or not empty. Empty organization key is invalid.");
            return new CreateRequest(this);
        }
    }
}

