/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client.projectanalysis;

import com.google.common.base.Preconditions;
import org.sonarqube.ws.client.projectanalysis.EventCategory;

public class CreateEventRequest {
    private final String analysis;
    private final EventCategory category;
    private final String name;

    private CreateEventRequest(Builder builder) {
        this.analysis = builder.analysis;
        this.category = builder.category;
        this.name = builder.name;
    }

    public String getAnalysis() {
        return this.analysis;
    }

    public EventCategory getCategory() {
        return this.category;
    }

    public String getName() {
        return this.name;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String analysis;
        private EventCategory category = EventCategory.OTHER;
        private String name;

        private Builder() {
        }

        public Builder setAnalysis(String analysis) {
            this.analysis = analysis;
            return this;
        }

        public Builder setCategory(EventCategory category) {
            this.category = category;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public CreateEventRequest build() {
            Preconditions.checkArgument((this.analysis != null ? 1 : 0) != 0, (Object)"Analysis key is required");
            Preconditions.checkArgument((this.category != null ? 1 : 0) != 0, (Object)"Category is required");
            Preconditions.checkArgument((this.name != null ? 1 : 0) != 0, (Object)"Name is required");
            return new CreateEventRequest(this);
        }
    }
}

