/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client.project;

import com.google.common.base.Preconditions;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class UpdateKeyWsRequest {
    private final String id;
    private final String key;
    private final String newKey;

    public UpdateKeyWsRequest(Builder builder) {
        this.id = builder.id;
        this.key = builder.key;
        this.newKey = builder.newKey;
    }

    @CheckForNull
    public String getId() {
        return this.id;
    }

    @CheckForNull
    public String getKey() {
        return this.key;
    }

    public String getNewKey() {
        return this.newKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String id;
        private String key;
        private String newKey;

        private Builder() {
        }

        public Builder setId(@Nullable String id) {
            this.id = id;
            return this;
        }

        public Builder setKey(@Nullable String key) {
            this.key = key;
            return this;
        }

        public Builder setNewKey(String newKey) {
            this.newKey = newKey;
            return this;
        }

        public UpdateKeyWsRequest build() {
            Preconditions.checkArgument((this.newKey != null && !this.newKey.isEmpty() ? 1 : 0) != 0, (Object)"The new key must not be empty");
            return new UpdateKeyWsRequest(this);
        }
    }
}

