/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client.project;

import com.google.common.base.Joiner;
import org.sonarqube.ws.WsProjects;
import org.sonarqube.ws.client.BaseService;
import org.sonarqube.ws.client.GetRequest;
import org.sonarqube.ws.client.PostRequest;
import org.sonarqube.ws.client.WsConnector;
import org.sonarqube.ws.client.WsRequest;
import org.sonarqube.ws.client.project.BulkUpdateKeyWsRequest;
import org.sonarqube.ws.client.project.CreateRequest;
import org.sonarqube.ws.client.project.DeleteRequest;
import org.sonarqube.ws.client.project.SearchWsRequest;
import org.sonarqube.ws.client.project.UpdateKeyWsRequest;
import org.sonarqube.ws.client.project.UpdateVisibilityRequest;

public class ProjectsService
extends BaseService {
    public ProjectsService(WsConnector wsConnector) {
        super(wsConnector, "api/projects");
    }

    public WsProjects.CreateWsResponse create(CreateRequest project) {
        PostRequest request = (PostRequest)((PostRequest)((PostRequest)((PostRequest)((PostRequest)new PostRequest(this.path("create")).setParam("organization", project.getOrganization())).setParam("project", project.getKey())).setParam("name", project.getName())).setParam("branch", project.getBranch())).setParam("visibility", project.getVisibility());
        return this.call(request, WsProjects.CreateWsResponse.parser());
    }

    public void delete(DeleteRequest request) {
        this.call((WsRequest)new PostRequest(this.path("delete")).setParam("project", request.getKey()));
    }

    public void bulkDelete(SearchWsRequest request) {
        PostRequest post = (PostRequest)((PostRequest)((PostRequest)((PostRequest)((PostRequest)((PostRequest)((PostRequest)new PostRequest(this.path("bulk_delete")).setParam("organization", request.getOrganization())).setParam("qualifiers", ProjectsService.inlineMultipleParamValue(request.getQualifiers()))).setParam("analyzedBefore", request.getAnalyzedBefore())).setParam("q", request.getQuery())).setParam("onProvisionedOnly", request.isOnProvisionedOnly())).setParam("projects", ProjectsService.inlineMultipleParamValue(request.getProjects()))).setParam("projectIds", ProjectsService.inlineMultipleParamValue(request.getProjectIds()));
        this.call(post);
    }

    public void updateKey(UpdateKeyWsRequest request) {
        PostRequest post = (PostRequest)((PostRequest)((PostRequest)new PostRequest(this.path("update_key")).setParam("projectId", request.getId())).setParam("from", request.getKey())).setParam("to", request.getNewKey());
        this.call(post);
    }

    public WsProjects.BulkUpdateKeyWsResponse bulkUpdateKey(BulkUpdateKeyWsRequest request) {
        PostRequest post = (PostRequest)((PostRequest)((PostRequest)((PostRequest)new PostRequest(this.path("bulk_update_key")).setParam("projectId", request.getId())).setParam("project", request.getKey())).setParam("from", request.getFrom())).setParam("to", request.getTo());
        return this.call(post, WsProjects.BulkUpdateKeyWsResponse.parser());
    }

    public WsProjects.SearchWsResponse search(SearchWsRequest request) {
        GetRequest get = (GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)new GetRequest(this.path("search")).setParam("organization", request.getOrganization())).setParam("qualifiers", Joiner.on((String)",").join(request.getQualifiers()))).setParam("analyzedBefore", request.getAnalyzedBefore())).setParam("q", request.getQuery())).setParam("p", request.getPage())).setParam("ps", request.getPageSize())).setParam("onProvisionedOnly", request.isOnProvisionedOnly())).setParam("projects", ProjectsService.inlineMultipleParamValue(request.getProjects()))).setParam("projectIds", ProjectsService.inlineMultipleParamValue(request.getProjectIds()));
        return this.call(get, WsProjects.SearchWsResponse.parser());
    }

    public void updateVisibility(UpdateVisibilityRequest request) {
        PostRequest post = (PostRequest)((PostRequest)new PostRequest(this.path("update_visibility")).setParam("project", request.getProject())).setParam("visibility", request.getVisibility());
        this.call(post);
    }
}

