/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client.measure;

import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public class SearchHistoryRequest {
    public static final int MAX_PAGE_SIZE = 1000;
    public static final int DEFAULT_PAGE_SIZE = 100;
    private final String component;
    private final String branch;
    private final List<String> metrics;
    private final String from;
    private final String to;
    private final int page;
    private final int pageSize;

    public SearchHistoryRequest(Builder builder) {
        this.component = builder.component;
        this.branch = builder.branch;
        this.metrics = builder.metrics;
        this.from = builder.from;
        this.to = builder.to;
        this.page = builder.page;
        this.pageSize = builder.pageSize;
    }

    public String getComponent() {
        return this.component;
    }

    @CheckForNull
    public String getBranch() {
        return this.branch;
    }

    public List<String> getMetrics() {
        return this.metrics;
    }

    @CheckForNull
    public String getFrom() {
        return this.from;
    }

    @CheckForNull
    public String getTo() {
        return this.to;
    }

    public int getPage() {
        return this.page;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String component;
        private String branch;
        private List<String> metrics;
        private String from;
        private String to;
        private int page = 1;
        private int pageSize = 100;

        private Builder() {
        }

        public Builder setComponent(String component) {
            this.component = component;
            return this;
        }

        public Builder setBranch(@Nullable String branch) {
            this.branch = branch;
            return this;
        }

        public Builder setMetrics(List<String> metrics) {
            this.metrics = metrics;
            return this;
        }

        public Builder setFrom(@Nullable String from) {
            this.from = from;
            return this;
        }

        public Builder setTo(@Nullable String to) {
            this.to = to;
            return this;
        }

        public Builder setPage(int page) {
            this.page = page;
            return this;
        }

        public Builder setPageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public SearchHistoryRequest build() {
            Builder.checkArgument(this.component != null && !this.component.isEmpty(), "Component key is required", new Object[0]);
            Builder.checkArgument(this.metrics != null && !this.metrics.isEmpty(), "Metric keys are required", new Object[0]);
            Builder.checkArgument(this.pageSize <= 1000, "Page size (%d) must be lower than or equal to %d", this.pageSize, 1000);
            return new SearchHistoryRequest(this);
        }

        private static void checkArgument(boolean condition, String message, Object ... args) {
            if (!condition) {
                throw new IllegalArgumentException(String.format(message, args));
            }
        }
    }
}

