/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client.ce;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class TaskWsRequest {
    private final String taskUuid;
    private final List<String> additionalFields;

    private TaskWsRequest(Builder builder) {
        this.taskUuid = builder.taskUuid;
        this.additionalFields = TaskWsRequest.createAdditionalFields(builder);
    }

    public static Builder newBuilder(String taskUuid) {
        return new Builder(taskUuid);
    }

    private static List<String> createAdditionalFields(Builder builder) {
        if (!builder.errorStacktrace && !builder.scannerContext) {
            return Collections.emptyList();
        }
        ArrayList<String> res = new ArrayList<String>(2);
        if (builder.errorStacktrace) {
            res.add("stacktrace");
        }
        if (builder.scannerContext) {
            res.add("scannerContext");
        }
        return ImmutableList.copyOf(res);
    }

    public String getTaskUuid() {
        return this.taskUuid;
    }

    public List<String> getAdditionalFields() {
        return this.additionalFields;
    }

    public static final class Builder {
        private final String taskUuid;
        private boolean errorStacktrace = false;
        private boolean scannerContext = false;

        private Builder(String taskUuid) {
            this.taskUuid = taskUuid;
        }

        public Builder withErrorStacktrace() {
            this.errorStacktrace = true;
            return this;
        }

        public Builder withScannerContext() {
            this.scannerContext = true;
            return this;
        }

        public TaskWsRequest build() {
            return new TaskWsRequest(this);
        }
    }
}

