/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.test.html;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMultipart;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.sonar.test.html.HtmlFragmentAssert;

public class MultipartMessageAssert
extends AbstractAssert<MultipartMessageAssert, Multipart> {
    private final Iterator<BodyPart> bodyParts;

    MultipartMessageAssert(MimeMultipart m) {
        super((Object)m, MultipartMessageAssert.class);
        try {
            this.bodyParts = new BodyPartIterator(m, m.getCount());
        }
        catch (MessagingException e) {
            throw new IllegalStateException(e);
        }
    }

    public HtmlFragmentAssert isHtml() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.bodyParts.hasNext()).describedAs("no more body part", new Object[0])).isTrue();
        try {
            BodyPart bodyPart = this.bodyParts.next();
            return new HtmlFragmentAssert((String)bodyPart.getContent());
        }
        catch (IOException | MessagingException e) {
            throw new IllegalStateException(e);
        }
    }

    private static class BodyPartIterator
    implements Iterator<BodyPart> {
        private final int count;
        private final MimeMultipart m;
        private int index = 0;

        public BodyPartIterator(MimeMultipart m, int count) {
            this.m = m;
            this.count = count;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.count;
        }

        @Override
        public BodyPart next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException("no more body part");
            }
            try {
                BodyPart next = this.m.getBodyPart(this.index);
                ++this.index;
                return next;
            }
            catch (MessagingException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

