/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.test.html;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.sonar.test.html.HtmlBlockAssert;
import org.sonar.test.html.HtmlListAssert;

public class HtmlParagraphAssert
extends HtmlBlockAssert<HtmlParagraphAssert> {
    private final Iterator<Element> nextBlocks;

    public HtmlParagraphAssert(Element paragraph, Iterator<Element> nextBlocks) {
        super(paragraph, HtmlParagraphAssert.class);
        this.nextBlocks = nextBlocks;
    }

    static void verifyIsParagraph(Element element) {
        ((AbstractStringAssert)Assertions.assertThat((String)element.tagName()).describedAs("next block is not a <%s> (got <%s>):\n---fragment---\n%s\n---fragment---", new Object[]{"p", element.tagName(), element.toString()})).isEqualTo("p");
    }

    public HtmlParagraphAssert hasParagraph() {
        return new HtmlParagraphAssert(this.hasParagraphImpl(), this.nextBlocks);
    }

    private Element hasParagraphImpl() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.nextBlocks.hasNext()).describedAs("no more bloc", new Object[0])).isTrue();
        Element element = this.nextBlocks.next();
        HtmlParagraphAssert.verifyIsParagraph(element);
        return element;
    }

    public HtmlParagraphAssert hasParagraph(String text) {
        return this.hasParagraph().withText(text);
    }

    public HtmlParagraphAssert hasEmptyParagraph() {
        Element paragraph = this.hasParagraphImpl();
        ((AbstractStringAssert)Assertions.assertThat((String)paragraph.text()).describedAs("\n---fragment---\n%s\n---fragment---", new Object[]{paragraph})).isIn(new Object[]{"", "\u00a0"});
        return new HtmlParagraphAssert(paragraph, this.nextBlocks);
    }

    public void noMoreBlock() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.nextBlocks.hasNext()).describedAs("there are still some paragraph. Next one:\n---fragment---\n%s\n---fragment---", new Object[]{new Object(){

            public String toString() {
                return HtmlParagraphAssert.this.nextBlocks.next().toString();
            }
        }})).isFalse();
    }

    public HtmlParagraphAssert withText(String text) {
        this.isNotNull();
        ((AbstractStringAssert)Assertions.assertThat((String)((Element)this.actual).text()).describedAs("\n---fragment---\n%s\n---fragment---", new Object[]{this.actual})).isEqualTo(text);
        return this;
    }

    public HtmlParagraphAssert withLines(String firstLine, String ... otherLines) {
        this.isNotNull();
        List<String> actualLines = HtmlParagraphAssert.toLines((Element)this.actual);
        Object[] expectedLines = (String[])Stream.concat(Stream.of(firstLine), Arrays.stream(otherLines)).toArray(String[]::new);
        ((ListAssert)Assertions.assertThat(actualLines).describedAs("\n---fragment---\n%s\n---fragment---", new Object[]{this.actual})).containsExactly(expectedLines);
        return this;
    }

    private static List<String> toLines(Element parent) {
        Iterator iterator = parent.childNodes().iterator();
        if (!iterator.hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<String> actualLines = new ArrayList<String>(parent.childNodeSize());
        StringBuilder currentLine = null;
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (node instanceof TextNode) {
                if (currentLine == null) {
                    currentLine = new StringBuilder(node.toString());
                } else {
                    currentLine.append(node.toString());
                }
            } else if (node instanceof Element) {
                Element element = (Element)node;
                if (element.tagName().equals("br")) {
                    actualLines.add(currentLine == null ? "" : currentLine.toString());
                    currentLine = null;
                } else if (currentLine == null) {
                    currentLine = new StringBuilder(element.text());
                } else {
                    currentLine.append(element.text());
                }
            } else {
                throw new IllegalStateException("unsupported node " + node.getClass());
            }
            if (iterator.hasNext()) continue;
            actualLines.add(currentLine == null ? "" : currentLine.toString());
            currentLine = null;
        }
        return actualLines;
    }

    public HtmlListAssert hasList(String firstItemText, String ... otherItemsText) {
        return this.hasList().withItemTexts(firstItemText, otherItemsText);
    }

    public HtmlListAssert hasList() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.nextBlocks.hasNext()).describedAs("no more block", new Object[0])).isTrue();
        Element element = this.nextBlocks.next();
        HtmlListAssert.verifyIsList(element);
        return new HtmlListAssert(element, this.nextBlocks);
    }
}

