/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.test.html;

import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.util.Preconditions;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public abstract class HtmlBlockAssert<T extends HtmlBlockAssert<T>>
extends AbstractAssert<T, Element> {
    static final String PRINT_FRAGMENT_TEMPLATE = "\n---fragment---\n%s\n---fragment---";
    private static final String NO_LINK_IN_BLOC = "no link in bloc";

    public HtmlBlockAssert(Element v, Class<T> selfType) {
        super((Object)v, selfType);
    }

    public T withLinkOn(String linkText) {
        return this.withLinkOn(linkText, 1);
    }

    public T withLinkOn(String linkText, int times) {
        Preconditions.checkArgument((times >= 1 ? 1 : 0) != 0, (String)"times must be >= 1", (Object[])new Object[0]);
        this.isNotNull();
        Elements as = ((Element)this.actual).select("a");
        ((ListAssert)Assertions.assertThat((List)as).describedAs("no link in bloc\n---fragment---\n%s\n---fragment---", new Object[]{this.actual})).isNotEmpty();
        long count = as.stream().filter(t -> linkText.equals(t.text())).count();
        if (count != (long)times) {
            this.failWithMessage("link on text \"%s\" found %s times in bloc (expected %s). \n Got: %s", new Object[]{linkText, count, times, HtmlBlockAssert.asyncLinksToString(as)});
        }
        return (T)((Object)((HtmlBlockAssert)this.myself));
    }

    public T withLink(String linkText, String href) {
        this.isNotNull();
        Elements as = ((Element)this.actual).select("a");
        ((ListAssert)Assertions.assertThat((List)as).describedAs("no link in bloc\n---fragment---\n%s\n---fragment---", new Object[]{this.actual})).isNotEmpty();
        if (as.stream().noneMatch(t -> linkText.equals(t.text()) && href.equals(t.attr("href")))) {
            this.failWithMessage("link with text \"%s\" and href \"%s\" not found in block. \n Got: %s\n---fragment---\n%s\n---fragment---", new Object[]{linkText, href, HtmlBlockAssert.asyncLinksToString(as), this.actual});
        }
        return (T)((Object)((HtmlBlockAssert)this.myself));
    }

    public T withoutLink() {
        this.isNotNull();
        Assertions.assertThat((List)((Element)this.actual).select("a")).isEmpty();
        return (T)((Object)((HtmlBlockAssert)this.myself));
    }

    private static Object asyncLinksToString(final Elements linkElements) {
        return new Object(){

            public String toString() {
                return linkElements.stream().map(a -> "<a href=\"" + a.attr("href") + "\">" + a.text() + "<a>").collect(Collectors.joining("\n"));
            }
        };
    }

    public T withEmphasisOn(String emphasisText) {
        this.isNotNull();
        Elements emphases = ((Element)this.actual).select("em");
        ((ListAssert)Assertions.assertThat((List)emphases).describedAs("no <em> in block", new Object[0])).isNotEmpty();
        Assertions.assertThat(emphases.stream().map(Element::text)).contains((Object[])new String[]{emphasisText});
        return (T)((Object)((HtmlBlockAssert)this.myself));
    }

    public T withSmallOn(String emphasisText) {
        this.isNotNull();
        Elements smalls = ((Element)this.actual).select("small");
        ((ListAssert)Assertions.assertThat((List)smalls).describedAs("no <small> in block", new Object[0])).isNotEmpty();
        Assertions.assertThat(smalls.stream().map(Element::text)).contains((Object[])new String[]{emphasisText});
        return (T)((Object)((HtmlBlockAssert)this.myself));
    }
}

