/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.ws;

import com.google.common.base.Strings;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Languages;
import org.sonar.api.utils.Paging;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonarqube.ws.Common;

public class WsResponseCommonFormat {
    private final Languages languages;

    public WsResponseCommonFormat(Languages languages) {
        this.languages = languages;
    }

    public Common.Paging.Builder formatPaging(Paging paging) {
        return Common.Paging.newBuilder().setPageIndex(paging.pageIndex()).setPageSize(paging.pageSize()).setTotal(paging.total());
    }

    public Common.Rule.Builder formatRule(RuleDefinitionDto rule) {
        Common.Rule.Builder builder = Common.Rule.newBuilder().setKey(rule.getKey().toString()).setName(Strings.nullToEmpty((String)rule.getName())).setStatus(Common.RuleStatus.valueOf((String)rule.getStatus().name()));
        builder.setLang(Strings.nullToEmpty((String)rule.getLanguage()));
        Language lang = this.languages.get(rule.getLanguage());
        if (lang != null) {
            builder.setLangName(lang.getName());
        }
        return builder;
    }
}

