/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.webhook.ws;

import com.google.common.base.Preconditions;
import com.google.common.io.Resources;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.Paging;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.webhook.WebhookDeliveryLiteDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.user.UserSession;
import org.sonar.server.webhook.ws.WebhookWsSupport;
import org.sonar.server.webhook.ws.WebhooksWsAction;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Common;
import org.sonarqube.ws.Webhooks;

public class WebhookDeliveriesAction
implements WebhooksWsAction {
    private static final String PARAM_COMPONENT = "componentKey";
    private static final String PARAM_TASK = "ceTaskId";
    private static final String PARAM_WEBHOOK = "webhook";
    private final DbClient dbClient;
    private final UserSession userSession;
    private final ComponentFinder componentFinder;

    public WebhookDeliveriesAction(DbClient dbClient, UserSession userSession, ComponentFinder componentFinder) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.componentFinder = componentFinder;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("deliveries").setSince("6.2").setDescription("Get the recent deliveries for a specified project or Compute Engine task.<br/>Require 'Administer' permission on the related project.<br/>Note that additional information are returned by api/webhooks/delivery.").setResponseExample(Resources.getResource(this.getClass(), (String)"example-deliveries.json")).setHandler((RequestHandler)this);
        action.createParam(PARAM_COMPONENT).setDescription("Key of the project").setExampleValue((Object)"my-project");
        action.createParam(PARAM_TASK).setDescription("Id of the Compute Engine task").setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy");
        action.createParam(PARAM_WEBHOOK).setSince("7.1").setDescription("Key of the webhook that triggered those deliveries,auto-generated value that can be obtained through api/webhooks/create or api/webhooks/list").setExampleValue((Object)"AU-TpxcA-iU5OvuD2FLz");
        action.addPagingParamsSince(10, 500, "7.1");
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn();
        String ceTaskId = request.param(PARAM_TASK);
        String componentKey = request.param(PARAM_COMPONENT);
        String webhookUuid = request.param(PARAM_WEBHOOK);
        int page = request.mandatoryParamAsInt("p");
        int pageSize = request.mandatoryParamAsInt("ps");
        Preconditions.checkArgument((boolean)(webhookUuid != null ^ (ceTaskId != null ^ componentKey != null)), (String)"Either '%s' or '%s' or '%s' must be provided", (Object[])new Object[]{PARAM_TASK, PARAM_COMPONENT, PARAM_WEBHOOK});
        Data data = this.loadFromDatabase(webhookUuid, ceTaskId, componentKey, page, pageSize);
        data.ensureAdminPermission(this.userSession);
        data.writeTo(request, response);
    }

    private Data loadFromDatabase(@Nullable String webhookUuid, @Nullable String ceTaskId, @Nullable String componentKey, int page, int pageSize) {
        ComponentDto component;
        List deliveries;
        int totalElements;
        try (DbSession dbSession = this.dbClient.openSession(false);){
            if (StringUtils.isNotBlank((String)webhookUuid)) {
                totalElements = this.dbClient.webhookDeliveryDao().countDeliveriesByWebhookUuid(dbSession, webhookUuid);
                deliveries = this.dbClient.webhookDeliveryDao().selectByWebhookUuid(dbSession, webhookUuid, Paging.offset((int)page, (int)pageSize), pageSize);
                component = this.getComponentDto(dbSession, deliveries);
            } else if (componentKey != null) {
                component = this.componentFinder.getByKey(dbSession, componentKey);
                totalElements = this.dbClient.webhookDeliveryDao().countDeliveriesByComponentUuid(dbSession, component.uuid());
                deliveries = this.dbClient.webhookDeliveryDao().selectOrderedByComponentUuid(dbSession, component.uuid(), Paging.offset((int)page, (int)pageSize), pageSize);
            } else {
                totalElements = this.dbClient.webhookDeliveryDao().countDeliveriesByCeTaskUuid(dbSession, ceTaskId);
                deliveries = this.dbClient.webhookDeliveryDao().selectOrderedByCeTaskUuid(dbSession, ceTaskId, Paging.offset((int)page, (int)pageSize), pageSize);
                component = this.getComponentDto(dbSession, deliveries);
            }
        }
        return new Data(component, deliveries).withPagingInfo(page, pageSize, totalElements);
    }

    private ComponentDto getComponentDto(DbSession dbSession, List<WebhookDeliveryLiteDto> deliveries) {
        Optional<String> deliveredComponentUuid = deliveries.stream().map(WebhookDeliveryLiteDto::getComponentUuid).findFirst();
        if (deliveredComponentUuid.isPresent()) {
            return this.componentFinder.getByUuid(dbSession, deliveredComponentUuid.get());
        }
        return null;
    }

    private static class Data {
        private final ComponentDto component;
        private final List<WebhookDeliveryLiteDto> deliveryDtos;
        private int pageIndex;
        private int pageSize;
        private int totalElements;

        Data(@Nullable ComponentDto component, List<WebhookDeliveryLiteDto> deliveries) {
            this.deliveryDtos = deliveries;
            this.component = deliveries.isEmpty() ? null : Objects.requireNonNull(component);
        }

        void ensureAdminPermission(UserSession userSession) {
            if (this.component != null) {
                userSession.checkComponentPermission("admin", this.component);
            }
        }

        void writeTo(Request request, Response response) {
            Webhooks.DeliveriesWsResponse.Builder responseBuilder = Webhooks.DeliveriesWsResponse.newBuilder();
            Webhooks.Delivery.Builder deliveryBuilder = Webhooks.Delivery.newBuilder();
            for (WebhookDeliveryLiteDto dto : this.deliveryDtos) {
                WebhookWsSupport.copyDtoToProtobuf(this.component, dto, deliveryBuilder);
                responseBuilder.addDeliveries(deliveryBuilder);
            }
            responseBuilder.setPaging(Data.buildPaging(this.pageIndex, this.pageSize, this.totalElements));
            WsUtils.writeProtobuf((Message)responseBuilder.build(), request, response);
        }

        static Common.Paging buildPaging(int pageIndex, int pageSize, int totalElements) {
            return Common.Paging.newBuilder().setPageIndex(pageIndex).setPageSize(pageSize).setTotal(totalElements).build();
        }

        public Data withPagingInfo(int pageIndex, int pageSize, int totalElements) {
            this.pageIndex = pageIndex;
            this.pageSize = pageSize;
            this.totalElements = totalElements;
            return this;
        }
    }
}

