/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.view.index;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.index.IndexRequest;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.UuidWithProjectUuidDto;
import org.sonar.db.es.EsQueueDto;
import org.sonar.server.es.BulkIndexer;
import org.sonar.server.es.EsClient;
import org.sonar.server.es.IndexType;
import org.sonar.server.es.IndexingListener;
import org.sonar.server.es.IndexingResult;
import org.sonar.server.es.OneToOneResilientIndexingListener;
import org.sonar.server.es.ResilientIndexer;
import org.sonar.server.view.index.ViewDoc;
import org.sonar.server.view.index.ViewIndexDefinition;

public class ViewIndexer
implements ResilientIndexer {
    private final DbClient dbClient;
    private final EsClient esClient;

    public ViewIndexer(DbClient dbClient, EsClient esClient) {
        this.dbClient = dbClient;
        this.esClient = esClient;
    }

    @Override
    public Set<IndexType> getIndexTypes() {
        return ImmutableSet.of((Object)ViewIndexDefinition.INDEX_TYPE_VIEW);
    }

    @Override
    public void indexOnStartup(Set<IndexType> uninitializedIndexTypes) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            HashMap viewAndProjectViewUuidMap = Maps.newHashMap();
            for (UuidWithProjectUuidDto uuidWithProjectUuidDto : this.dbClient.componentDao().selectAllViewsAndSubViews(dbSession)) {
                viewAndProjectViewUuidMap.put(uuidWithProjectUuidDto.getUuid(), uuidWithProjectUuidDto.getProjectUuid());
            }
            this.index(dbSession, viewAndProjectViewUuidMap, false, BulkIndexer.Size.LARGE);
        }
    }

    public void index(String rootViewUuid) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            HashMap viewAndProjectViewUuidMap = Maps.newHashMap();
            for (ComponentDto viewOrSubView : this.dbClient.componentDao().selectEnabledDescendantModules(dbSession, rootViewUuid)) {
                viewAndProjectViewUuidMap.put(viewOrSubView.uuid(), viewOrSubView.projectUuid());
            }
            this.index(dbSession, viewAndProjectViewUuidMap, true, BulkIndexer.Size.REGULAR);
        }
    }

    public void index(ViewDoc viewDoc) {
        BulkIndexer bulk = new BulkIndexer(this.esClient, ViewIndexDefinition.INDEX_TYPE_VIEW, BulkIndexer.Size.REGULAR);
        bulk.start();
        this.doIndex(bulk, viewDoc, true);
        bulk.stop();
    }

    private void index(DbSession dbSession, Map<String, String> viewAndProjectViewUuidMap, boolean needClearCache, BulkIndexer.Size bulkSize) {
        BulkIndexer bulk = new BulkIndexer(this.esClient, ViewIndexDefinition.INDEX_TYPE_VIEW, bulkSize);
        bulk.start();
        for (Map.Entry<String, String> entry : viewAndProjectViewUuidMap.entrySet()) {
            String viewUuid = entry.getKey();
            List projects = this.dbClient.componentDao().selectProjectsFromView(dbSession, viewUuid, entry.getValue());
            this.doIndex(bulk, new ViewDoc().setUuid(viewUuid).setProjects(projects), needClearCache);
        }
        bulk.stop();
    }

    private void doIndex(BulkIndexer bulk, ViewDoc viewDoc, boolean needClearCache) {
        bulk.add(ViewIndexer.newIndexRequest(viewDoc));
        if (needClearCache) {
            this.clearLookupCache(viewDoc.uuid());
        }
    }

    private static IndexRequest newIndexRequest(ViewDoc doc) {
        return new IndexRequest(ViewIndexDefinition.INDEX_TYPE_VIEW.getIndex(), ViewIndexDefinition.INDEX_TYPE_VIEW.getType(), doc.uuid()).source(doc.getFields());
    }

    private void clearLookupCache(String viewUuid) {
        try {
            this.esClient.prepareClearCache(new String[0]).setQueryCache(true).get();
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Unable to clear lookup cache of view '%s'", viewUuid), e);
        }
    }

    @Override
    public IndexingResult index(DbSession dbSession, Collection<EsQueueDto> items) {
        if (items.isEmpty()) {
            return new IndexingResult();
        }
        Set views = (Set)items.stream().map(EsQueueDto::getDocId).collect(MoreCollectors.toHashSet((int)items.size()));
        BulkIndexer bulkIndexer = this.newBulkIndexer(BulkIndexer.Size.REGULAR, new OneToOneResilientIndexingListener(this.dbClient, dbSession, items));
        bulkIndexer.start();
        views.removeAll(this.dbClient.componentDao().selectExistingUuids(dbSession, (Collection)views));
        views.forEach(v -> bulkIndexer.addDeletion(ViewIndexDefinition.INDEX_TYPE_VIEW, (String)v));
        return bulkIndexer.stop();
    }

    public void delete(DbSession dbSession, Collection<String> viewUuids) {
        List items = (List)viewUuids.stream().map(l -> EsQueueDto.create((String)ViewIndexDefinition.INDEX_TYPE_VIEW.format(), (String)l)).collect(MoreCollectors.toArrayList());
        this.dbClient.esQueueDao().insert(dbSession, (Collection)items);
        dbSession.commit();
        this.index(dbSession, items);
    }

    private BulkIndexer newBulkIndexer(BulkIndexer.Size bulkSize, IndexingListener listener) {
        return new BulkIndexer(this.esClient, ViewIndexDefinition.INDEX_TYPE_VIEW, bulkSize, listener);
    }
}

