/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.util.cache;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.sonar.api.utils.System2;
import org.sonar.core.util.CloseableIterator;
import org.sonar.server.util.ObjectInputStreamIterator;

public class DiskCache<O extends Serializable> {
    private final File file;
    private final System2 system2;

    public DiskCache(File file, System2 system2) {
        block7: {
            ObjectOutputStream output;
            block6: {
                this.system2 = system2;
                this.file = file;
                output = null;
                boolean threw = true;
                try {
                    output = new ObjectOutputStream(new FileOutputStream(file));
                    ((OutputStream)output).flush();
                    threw = false;
                    if (!threw) break block6;
                }
                catch (IOException e) {
                    try {
                        throw new IllegalStateException("Fail to write into file: " + file, e);
                    }
                    catch (Throwable throwable) {
                        if (threw) {
                            IOUtils.closeQuietly(output);
                        } else {
                            system2.close(output);
                        }
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((OutputStream)output);
                break block7;
            }
            system2.close((AutoCloseable)output);
        }
    }

    public DiskAppender newAppender() {
        return new DiskAppender();
    }

    public CloseableIterator<O> traverse() {
        try {
            return new ObjectInputStreamIterator(FileUtils.openInputStream((File)this.file));
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to traverse file: " + this.file, e);
        }
    }

    public class DiskAppender
    implements AutoCloseable {
        private final ObjectOutputStream output;

        private DiskAppender() {
            try {
                this.output = new ObjectOutputStream(new FileOutputStream(DiskCache.this.file, true)){

                    @Override
                    protected void writeStreamHeader() {
                    }
                };
            }
            catch (IOException e) {
                throw new IllegalStateException("Fail to open file " + DiskCache.this.file, e);
            }
        }

        public DiskAppender append(O object) {
            try {
                this.output.writeObject(object);
                this.output.reset();
                return this;
            }
            catch (IOException e) {
                throw new IllegalStateException("Fail to write into file " + DiskCache.this.file, e);
            }
        }

        @Override
        public void close() {
            DiskCache.this.system2.close((AutoCloseable)this.output);
        }
    }
}

